/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.websocket.server;

import com.bizunited.nebula.gateway.websocket.server.config.NettyServerProperties;
import com.bizunited.nebula.gateway.websocket.server.handler.GatewayWebSocketHandler;
import com.bizunited.nebula.gateway.websocket.server.utils.SSLContextUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.server.Ssl;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class NioWebSocketServer
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioWebSocketServer.class);
    @Autowired
    private NettyServerProperties nettyServerProperties;
    @Autowired(required=false)
    private ServerProperties serverProperties;

    public void setApplicationContext(final ApplicationContext applicationContext) throws BeansException {
        final Ssl sslInfo = this.serverProperties.getSsl();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int availableProcessors = Runtime.getRuntime().availableProcessors();
                if (availableProcessors <= 4) {
                    availableProcessors = 4;
                }
                LOGGER.info("websocket processing ...... ");
                NioEventLoopGroup boss = new NioEventLoopGroup(1);
                NioEventLoopGroup work = new NioEventLoopGroup(availableProcessors);
                try {
                    ServerBootstrap bootstrap = new ServerBootstrap();
                    bootstrap.group((EventLoopGroup)boss, (EventLoopGroup)work);
                    bootstrap.channel(NioServerSocketChannel.class);
                    if (sslInfo != null && sslInfo.isEnabled()) {
                        bootstrap.childHandler((ChannelHandler)new ChannelInitializerForWss(applicationContext, sslInfo));
                    } else {
                        bootstrap.childHandler((ChannelHandler)new ChannelInitializerForWs(applicationContext));
                    }
                    Channel channel = bootstrap.bind(NioWebSocketServer.this.nettyServerProperties.getPort()).sync().channel();
                    LOGGER.info("websocket processed , port: {} ...... ", (Object)NioWebSocketServer.this.nettyServerProperties.getPort());
                    channel.closeFuture().sync();
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.out);
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    boss.shutdownGracefully();
                    work.shutdownGracefully();
                    LOGGER.info("websocket server close ......");
                }
            }
        }, "websocket-main-thread").start();
    }

    public class ChannelInitializerForWss
    extends ChannelInitializer<SocketChannel> {
        private ApplicationContext applicationContext;
        private Ssl sslInfo;

        public ChannelInitializerForWss(ApplicationContext applicationContext, Ssl sslInfo) {
            this.applicationContext = applicationContext;
            this.sslInfo = sslInfo;
        }

        protected void initChannel(SocketChannel channel) throws Exception {
            GatewayWebSocketHandler gatewayWebSocketHandler = (GatewayWebSocketHandler)((Object)this.applicationContext.getBean(GatewayWebSocketHandler.class));
            String keyStorePassword = this.sslInfo.getKeyStorePassword();
            String keyStore = this.sslInfo.getKeyStore();
            String keyStoreType = this.sslInfo.getKeyStoreType();
            SSLContext sslContext = SSLContextUtil.createSSLContext(keyStoreType, keyStore, keyStorePassword);
            SSLEngine engine = sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            channel.pipeline().addLast("ssl-handler", (ChannelHandler)new SslHandler(engine)).addLast("logging", (ChannelHandler)new LoggingHandler(LogLevel.DEBUG)).addLast("http-codec", (ChannelHandler)new HttpServerCodec(65535, 65535, 65535)).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(NioWebSocketServer.this.nettyServerProperties.getMaxBytesLen())).addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler()).addLast("handler", (ChannelHandler)gatewayWebSocketHandler);
        }
    }

    public class ChannelInitializerForWs
    extends ChannelInitializer<SocketChannel> {
        private ApplicationContext applicationContext;

        public ChannelInitializerForWs(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        protected void initChannel(SocketChannel channel) throws Exception {
            GatewayWebSocketHandler gatewayWebSocketHandler = (GatewayWebSocketHandler)((Object)this.applicationContext.getBean(GatewayWebSocketHandler.class));
            channel.pipeline().addLast("logging", (ChannelHandler)new LoggingHandler(LogLevel.DEBUG)).addLast("http-codec", (ChannelHandler)new HttpServerCodec(65535, 65535, 65535)).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(NioWebSocketServer.this.nettyServerProperties.getMaxBytesLen())).addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler()).addLast("handler", (ChannelHandler)gatewayWebSocketHandler);
        }
    }
}

