/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.websocket.server.controller;

import com.bizunited.nebula.gateway.websocket.server.config.NettyServerProperties;
import com.bizunited.nebula.gateway.websocket.server.controller.model.ResponseCode;
import com.bizunited.nebula.gateway.websocket.server.controller.model.ResponseModel;
import com.bizunited.nebula.gateway.websocket.server.dto.MsgSendDto;
import com.bizunited.nebula.gateway.websocket.server.service.ChannelMsgSendingService;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/websocket/notice"})
public class ChannelMsgSendingController {
    @Autowired
    private ChannelMsgSendingService channelMsgSendingService;
    @Autowired
    private NettyServerProperties nettyServerProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelMsgSendingController.class);

    @PostMapping(value={"/sendByTenantCodeAndApplicationNameAndModelCodeAndAccount"})
    public ResponseModel sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(@RequestBody MsgSendDto msgSendDto) {
        try {
            String account = msgSendDto.getAccount();
            String tenantCode = msgSendDto.getTenantCode();
            String applicationName = msgSendDto.getApplicationName();
            String modelCode = msgSendDto.getModelCode();
            String msgBase64 = msgSendDto.getMsgBase64();
            Validate.notBlank((CharSequence)msgBase64, (String)"msg for base64 not be blank.", (Object[])new Object[0]);
            byte[] msgBytes = Base64Utils.decodeFromString((String)msgBase64);
            int maxBytesLen = this.nettyServerProperties.getMaxBytesLen();
            Validate.isTrue((msgBytes.length <= maxBytesLen ? 1 : 0) != 0, (String)("msg over max len(" + maxBytesLen + ")!"), (Object[])new Object[0]);
            this.channelMsgSendingService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, applicationName, modelCode, account, msgBytes);
            ResponseModel responseModel = new ResponseModel();
            responseModel.setResponseCode(ResponseCode.E0);
            responseModel.setSuccess(true);
            return responseModel;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseModel responseModel = new ResponseModel(new Date().getTime(), null, ResponseCode.E501, e);
            return responseModel;
        }
    }

    @PostMapping(value={"/sendByTenantCodeAndApplicationNameAndModelCode"})
    public ResponseModel sendByTenantCodeAndApplicationNameAndModelCode(@RequestBody MsgSendDto msgSendDto) {
        try {
            String tenantCode = msgSendDto.getTenantCode();
            String applicationName = msgSendDto.getApplicationName();
            String modelCode = msgSendDto.getModelCode();
            String msgBase64 = msgSendDto.getMsgBase64();
            Validate.notBlank((CharSequence)msgBase64, (String)"msg for base64 not be blank.", (Object[])new Object[0]);
            byte[] msgBytes = Base64Utils.decodeFromString((String)msgBase64);
            int maxBytesLen = this.nettyServerProperties.getMaxBytesLen();
            Validate.isTrue((msgBytes.length <= maxBytesLen ? 1 : 0) != 0, (String)("msg over max len(" + maxBytesLen + ")!"), (Object[])new Object[0]);
            this.channelMsgSendingService.sendByTenantCodeAndApplicationNameAndModelCode(tenantCode, applicationName, modelCode, msgBytes);
            ResponseModel responseModel = new ResponseModel();
            responseModel.setResponseCode(ResponseCode.E0);
            responseModel.setSuccess(true);
            return responseModel;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseModel responseModel = new ResponseModel(new Date().getTime(), null, ResponseCode.E501, e);
            return responseModel;
        }
    }

    @PostMapping(value={"/sendByTenantCodeAndApplicationName"})
    public ResponseModel sendByTenantCodeAndApplicationName(@RequestBody MsgSendDto msgSendDto) {
        try {
            String tenantCode = msgSendDto.getTenantCode();
            String applicationName = msgSendDto.getApplicationName();
            String msgBase64 = msgSendDto.getMsgBase64();
            Validate.notBlank((CharSequence)msgBase64, (String)"msg for base64 not be blank.", (Object[])new Object[0]);
            byte[] msgBytes = Base64Utils.decodeFromString((String)msgBase64);
            int maxBytesLen = this.nettyServerProperties.getMaxBytesLen();
            Validate.isTrue((msgBytes.length <= maxBytesLen ? 1 : 0) != 0, (String)("msg over max len(" + maxBytesLen + ")!"), (Object[])new Object[0]);
            this.channelMsgSendingService.sendByTenantCodeAndApplicationName(tenantCode, applicationName, msgBytes);
            ResponseModel responseModel = new ResponseModel();
            responseModel.setResponseCode(ResponseCode.E0);
            responseModel.setSuccess(true);
            return responseModel;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseModel responseModel = new ResponseModel(new Date().getTime(), null, ResponseCode.E501, e);
            return responseModel;
        }
    }

    @PostMapping(value={"/sendByTenantCode"})
    public ResponseModel sendByTenantCode(@RequestBody MsgSendDto msgSendDto) {
        try {
            String tenantCode = msgSendDto.getTenantCode();
            String msgBase64 = msgSendDto.getMsgBase64();
            Validate.notBlank((CharSequence)msgBase64, (String)"msg for base64 not be blank.", (Object[])new Object[0]);
            byte[] msgBytes = Base64Utils.decodeFromString((String)msgBase64);
            int maxBytesLen = this.nettyServerProperties.getMaxBytesLen();
            Validate.isTrue((msgBytes.length <= maxBytesLen ? 1 : 0) != 0, (String)("msg over max len(" + maxBytesLen + ")!"), (Object[])new Object[0]);
            this.channelMsgSendingService.sendByTenantCode(tenantCode, msgBytes);
            ResponseModel responseModel = new ResponseModel();
            responseModel.setResponseCode(ResponseCode.E0);
            responseModel.setSuccess(true);
            return responseModel;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseModel responseModel = new ResponseModel(new Date().getTime(), null, ResponseCode.E501, e);
            return responseModel;
        }
    }
}

