/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.websocket.server.service.internal;

import com.bizunited.nebula.gateway.websocket.server.service.ChannelMsgSendingService;
import com.bizunited.nebula.gateway.websocket.server.service.ChannelUserMappingService;
import com.bizunited.nebula.gateway.websocket.server.vo.ChannelUserMappingVo;
import com.google.common.base.Charsets;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ChannelMsgSendingServiceImpl
implements ChannelMsgSendingService {
    @Autowired
    private ChannelUserMappingService channelUserMappingService;

    @Override
    public void sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(String tenantCode, String applicationName, String modelCode, String account, byte[] msg) {
        Validate.isTrue((msg != null && msg.length > 0 ? 1 : 0) != 0, (String)" msg not be empty ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)" tenantCode not be blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)applicationName, (String)"applicationName not blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)modelCode, (String)" modelCode not be blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)" account not be blank ", (Object[])new Object[0]);
        Set<ChannelUserMappingVo> channelUserMappings = this.channelUserMappingService.findByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, applicationName, modelCode, account);
        if (CollectionUtils.isEmpty(channelUserMappings)) {
            return;
        }
        this.send(channelUserMappings, msg);
    }

    @Override
    public void sendByTenantCodeAndApplicationNameAndModelCode(String tenantCode, String applicationName, String modelCode, byte[] msg) {
        Validate.isTrue((msg != null && msg.length > 0 ? 1 : 0) != 0, (String)" msg not be empty ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)" tenantCode not be blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)applicationName, (String)"applicationName not blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)modelCode, (String)" modelCode not be blank ", (Object[])new Object[0]);
        Set<ChannelUserMappingVo> channelUserMappings = this.channelUserMappingService.findByTenantCodeAndApplicationNameAndModelCode(tenantCode, applicationName, modelCode);
        if (CollectionUtils.isEmpty(channelUserMappings)) {
            return;
        }
        this.send(channelUserMappings, msg);
    }

    @Override
    public void sendByTenantCodeAndApplicationName(String tenantCode, String applicationName, byte[] msg) {
        Validate.isTrue((msg != null && msg.length > 0 ? 1 : 0) != 0, (String)" msg not be empty ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)" tenantCode not be blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)applicationName, (String)"applicationName not blank ", (Object[])new Object[0]);
        Set<ChannelUserMappingVo> channelUserMappings = this.channelUserMappingService.findByTenantCodeAndApplicationName(tenantCode, applicationName);
        if (CollectionUtils.isEmpty(channelUserMappings)) {
            return;
        }
        this.send(channelUserMappings, msg);
    }

    @Override
    public void sendByTenantCode(String tenantCode, byte[] msg) {
        Validate.isTrue((msg != null && msg.length > 0 ? 1 : 0) != 0, (String)" msg not be empty ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)" tenantCode not be blank ", (Object[])new Object[0]);
        Set<ChannelUserMappingVo> channelUserMappings = this.channelUserMappingService.findByTenantCode(tenantCode);
        if (CollectionUtils.isEmpty(channelUserMappings)) {
            return;
        }
        this.send(channelUserMappings, msg);
    }

    private void send(Set<ChannelUserMappingVo> channelUserMappings, byte[] msg) {
        for (ChannelUserMappingVo channelUserMapping : channelUserMappings) {
            Channel channel = channelUserMapping.getChannel();
            if (channel == null || !channel.isActive()) continue;
            TextWebSocketFrame socketFrame = new TextWebSocketFrame(StringUtils.toEncodedString((byte[])msg, (Charset)Charsets.UTF_8));
            channel.writeAndFlush((Object)socketFrame);
        }
    }
}

