/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.websocket.server.controller;

import com.bizunited.nebula.gateway.websocket.server.config.NettyServerProperties;
import com.bizunited.nebula.gateway.websocket.server.controller.model.ResponseCode;
import com.bizunited.nebula.gateway.websocket.server.controller.model.ResponseModel;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/websocket/properties"})
public class NettyServerPropertiesController {
    @Autowired
    private NettyServerProperties nettyServerProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServerPropertiesController.class);

    @PostMapping(value={"/findMaxBytesLen"})
    public ResponseModel findMaxBytesLen() {
        try {
            int maxBytesLen = this.nettyServerProperties.getMaxBytesLen();
            ResponseModel responseModel = new ResponseModel();
            responseModel.setResponseCode(ResponseCode.E0);
            responseModel.setData(maxBytesLen);
            responseModel.setSuccess(true);
            return responseModel;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseModel responseModel = new ResponseModel(new Date().getTime(), null, ResponseCode.E501, e);
            return responseModel;
        }
    }
}

