/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.websocket.server.handler;

import com.bizunited.nebula.gateway.websocket.server.config.NettyServerProperties;
import com.bizunited.nebula.gateway.websocket.server.service.ChannelUserMappingService;
import com.bizunited.nebula.gateway.websocket.server.vo.ChannelUserMappingVo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GatewayWebSocketHandler
extends SimpleChannelInboundHandler<Object> {
    @Autowired
    private NettyServerProperties nettyServerProperties;
    @Autowired
    private ChannelUserMappingService channelUserMappingService;
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayWebSocketHandler.class);

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.handlerHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handlerWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    private void handlerWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            ctx.close();
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (!(frame instanceof TextWebSocketFrame)) {
            // empty if block
        }
    }

    private void handlerHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
        Channel channel = ctx.channel();
        if (!req.decoderResult().isSuccess() || !"websocket".equals(req.headers().get("Upgrade"))) {
            GatewayWebSocketHandler.sendHttpResponse(ctx, req, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        URI requestUrl = null;
        ChannelUserMappingVo channelUserMapping = null;
        try {
            requestUrl = new URI(req.uri());
            channelUserMapping = this.analysisUriForQuery(requestUrl, channel);
            this.channelUserMappingService.createMapping(channelUserMapping);
        }
        catch (RuntimeException | URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            GatewayWebSocketHandler.sendHttpResponse(ctx, req, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory("wss://127.0.0.1:" + this.nettyServerProperties.getPort() + "/websocket", null, false);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            handshaker.handshake(ctx.channel(), req);
        }
    }

    private ChannelUserMappingVo analysisUriForQuery(URI requestUrl, Channel channel) {
        String query = requestUrl.getQuery();
        Validate.notBlank((CharSequence)query, (String)"not found query params , we need tenantCode,applicationName,modelCode and account", (Object[])new Object[0]);
        String[] queryParams = StringUtils.split((String)query, (String)"&");
        Validate.isTrue((queryParams != null && queryParams.length > 0 ? 1 : 0) != 0, (String)"not found query params array , we need tenantCode,applicationName,modelCode and account", (Object[])new Object[0]);
        ChannelUserMappingVo v = new ChannelUserMappingVo();
        for (String queryParam : queryParams) {
            String[] queryParamContents = StringUtils.split((String)queryParam, (String)"=");
            Validate.isTrue((queryParamContents != null && queryParamContents.length == 2 ? 1 : 0) != 0, (String)("queryParam:" + queryParam + " incorrect ."), (Object[])new Object[0]);
            String paramKey = queryParamContents[0];
            String paramValue = queryParamContents[1];
            if (StringUtils.equals((CharSequence)"tenantCode", (CharSequence)paramKey)) {
                v.setTenantCode(paramValue);
            }
            if (StringUtils.equals((CharSequence)"applicationName", (CharSequence)paramKey)) {
                v.setApplicationName(paramValue);
            }
            if (StringUtils.equals((CharSequence)"modelCode", (CharSequence)paramKey)) {
                v.setModelCode(paramValue);
            }
            if (!StringUtils.equals((CharSequence)"account", (CharSequence)paramKey)) continue;
            v.setAccount(paramValue);
        }
        v.setChannel(channel);
        Validate.isTrue((!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{v.getAccount(), v.getTenantCode(), v.getApplicationName(), v.getModelCode()}) ? 1 : 0) != 0, (String)"mapping params is blank at least one", (Object[])new Object[0]);
        return v;
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, DefaultFullHttpResponse res) {
        if (res.status().code() != 200) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (res.status().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        if (channel != null) {
            this.channelUserMappingService.deleteByChannel(channel);
        }
        super.channelInactive(ctx);
    }
}

