/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.websocket.server.service.internal;

import com.bizunited.nebula.gateway.websocket.server.service.ChannelUserMappingService;
import com.bizunited.nebula.gateway.websocket.server.vo.ChannelUserMappingVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ChannelUserMappingServiceImpl
implements ChannelUserMappingService {
    private Map<ChannelUserMappingVo, Channel> channelUserMapping = Maps.newConcurrentMap();

    @Override
    public void createMapping(ChannelUserMappingVo channelUserMappingVo) {
        Validate.notNull((Object)channelUserMappingVo, (String)"channelUserMappingVo is null", (Object[])new Object[0]);
        String account = channelUserMappingVo.getAccount();
        String tenantCode = channelUserMappingVo.getTenantCode();
        String applicationName = channelUserMappingVo.getApplicationName();
        String modelCode = channelUserMappingVo.getModelCode();
        Channel channel = channelUserMappingVo.getChannel();
        Validate.notBlank((CharSequence)account, (String)"account is blank!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)"tenantCode is blank!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)applicationName, (String)"applicationName is blank!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)modelCode, (String)"modelCode is blank!!", (Object[])new Object[0]);
        Validate.notNull((Object)channel, (String)"channel is null!", (Object[])new Object[0]);
        Validate.isTrue((boolean)channel.isActive(), (String)"channel is not active!", (Object[])new Object[0]);
        this.channelUserMapping.put(channelUserMappingVo, channel);
    }

    @Override
    public void deleteByChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        for (Map.Entry<ChannelUserMappingVo, Channel> entry : this.channelUserMapping.entrySet()) {
            if (entry.getValue() != channel) continue;
            ChannelUserMappingVo channelUserMappingVo = entry.getKey();
            this.channelUserMapping.remove(channelUserMappingVo);
            return;
        }
    }

    @Override
    public Set<ChannelUserMappingVo> findByTenantCodeAndApplicationNameAndModelCode(String tenantCode, String applicationName, String modelCode) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{tenantCode, applicationName, modelCode})) {
            return Sets.newConcurrentHashSet();
        }
        if (CollectionUtils.isEmpty(this.channelUserMapping)) {
            return Sets.newConcurrentHashSet();
        }
        Set<ChannelUserMappingVo> channelUserMappingResults = this.channelUserMapping.keySet().stream().filter(item -> {
            String currentTenantCode = item.getTenantCode();
            String currentApplicationName = item.getApplicationName();
            String currentModelCode = item.getModelCode();
            if (StringUtils.isNotBlank((CharSequence)tenantCode) && !StringUtils.equals((CharSequence)currentTenantCode, (CharSequence)tenantCode)) {
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)applicationName) && !StringUtils.equals((CharSequence)currentApplicationName, (CharSequence)applicationName)) {
                return false;
            }
            return !StringUtils.isNotBlank((CharSequence)modelCode) || StringUtils.equals((CharSequence)currentModelCode, (CharSequence)modelCode);
        }).collect(Collectors.toSet());
        return channelUserMappingResults;
    }

    @Override
    public Set<ChannelUserMappingVo> findByTenantCodeAndApplicationNameAndModelCodeAndAccount(String tenantCode, String applicationName, String modelCode, String account) {
        Set<ChannelUserMappingVo> channelUserMappingResults = this.findByTenantCodeAndApplicationNameAndModelCode(tenantCode, applicationName, modelCode);
        if (CollectionUtils.isEmpty(channelUserMappingResults)) {
            return null;
        }
        if (CollectionUtils.isEmpty(channelUserMappingResults = channelUserMappingResults.stream().filter(item -> {
            String currentAccount = item.getAccount();
            return StringUtils.equals((CharSequence)currentAccount, (CharSequence)account);
        }).collect(Collectors.toSet()))) {
            return null;
        }
        return channelUserMappingResults;
    }

    @Override
    public Set<ChannelUserMappingVo> findByTenantCodeAndApplicationName(String tenantCode, String applicationName) {
        return this.findByTenantCodeAndApplicationNameAndModelCode(tenantCode, applicationName, null);
    }

    @Override
    public Set<ChannelUserMappingVo> findByTenantCode(String tenantCode) {
        return this.findByTenantCodeAndApplicationNameAndModelCode(tenantCode, null, null);
    }
}

