/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.icon.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.icon.local.controller.IconController;
import com.bizunited.nebula.icon.sdk.dto.IconPaginationDto;
import com.bizunited.nebula.icon.sdk.service.IconVoService;
import com.bizunited.nebula.icon.sdk.vo.IconVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u56fe\u6807\u7ba1\u7406\uff1aIconVo\uff1a\u56fe\u6807\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/icon/icon"})
public class IconVoController
extends BaseController {
    @Autowired
    private IconVoService iconVoService;
    private static final Logger log = LoggerFactory.getLogger(IconController.class);

    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u53c2\u6570\u4e3apage\u548csize\uff0cpage\u4ece0\u5f00\u59cb\uff0csize\u9ed8\u8ba450;\u53ef\u4f20\u7684\u53c2\u6570\uff1aFunctionSubPaginationDto")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="iconPaginationDto", value="\u5206\u9875Dto") IconPaginationDto iconPaginationDto) {
        try {
            Page result = this.iconVoService.findByCondition(pageable, iconPaginationDto);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=false, paramType="query"), @ApiImplicitParam(name="iconCode", value="\u56fe\u6807\u7f16\u7801", required=false, paramType="query")})
    @ApiOperation(value="\u6839\u636e \u3010id\u3011 \u6216\u8005\u3010iconCode\u3011 \u67e5\u8be2\u4e00\u6761\u4fe1\u606f")
    @GetMapping(value={"/findByIdOrIconCode"})
    public ResponseModel findByIdOrIconCode(@RequestParam(value="id", required=false) String id, @RequestParam(value="iconCode", required=false) String iconCode) {
        try {
            IconVo respVo = this.iconVoService.findByIdOrIconCode(id, iconCode);
            return this.buildHttpResultW(respVo, new String[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

