/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.icon.local.repository.internal;

import com.bizunited.nebula.common.repository.PageRepositoryImpl;
import com.bizunited.nebula.icon.local.entity.IconEntity;
import com.bizunited.nebula.icon.local.repository.IconRepositoryCustom;
import com.bizunited.nebula.icon.sdk.dto.IconPaginationDto;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;

@Repository
public class IconRepositoryImpl
implements IconRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<IconEntity> findByCondition(Pageable pageable, IconPaginationDto iconPaginationDto) {
        StringBuilder hql = new StringBuilder("from IconEntity co where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from IconEntity co where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, String> parameter = new HashMap<String, String>();
        if (iconPaginationDto != null) {
            if (StringUtils.isNotBlank((CharSequence)iconPaginationDto.getIconName())) {
                condition.append(" AND co.iconName like CONCAT('%', :iconName,'%') ");
                parameter.put("iconName", iconPaginationDto.getIconName());
            }
            if (StringUtils.isNotBlank((CharSequence)iconPaginationDto.getIconType())) {
                condition.append(" AND co.iconType = :iconType ");
                parameter.put("iconType", iconPaginationDto.getIconType());
            }
        }
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        String sortStr = this.getSort(pageable, sort, "co");
        hql.append((CharSequence)condition).append(sortStr);
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }
}

