/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.icon.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.icon.local.service.IconService;
import com.bizunited.nebula.icon.sdk.dto.IconDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u56fe\u6807\u7ba1\u7406\uff1aIcon\uff1a\u56fe\u6807\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/icon/icon"})
public class IconController
extends BaseController {
    @Autowired
    private IconService iconService;
    private static final Logger log = LoggerFactory.getLogger(IconController.class);

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/createByIconDto"})
    public ResponseModel createByIconDto(@RequestBody IconDto iconDto) {
        try {
            this.iconService.createByIconDto(iconDto);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={"/updateByIconDto"})
    public ResponseModel updateByIconDto(@RequestBody IconDto iconDto) {
        try {
            this.iconService.updateByIconDto(iconDto);
            return this.buildHttpResult("\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteByIdIn"})
    public ResponseModel deleteByIdIn(@RequestParam List<String> ids) {
        try {
            this.iconService.deleteByIdIn(ids);
            return this.buildHttpResult("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

