/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.icon.local.service.internal;

import com.bizunited.nebula.common.service.CodeGeneratorService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.icon.local.entity.IconEntity;
import com.bizunited.nebula.icon.local.repository.IconRepository;
import com.bizunited.nebula.icon.local.service.IconService;
import com.bizunited.nebula.icon.sdk.dto.IconDto;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class IconServiceImpl
implements IconService {
    @Autowired(required=false)
    @Qualifier(value="CodeGeneratorService")
    private CodeGeneratorService codeGeneratorService;
    @Autowired(required=false)
    private IconRepository iconRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void createByIconDto(IconDto iconDto) {
        if (StringUtils.isEmpty((CharSequence)iconDto.getIconCode())) {
            String code = this.codeGeneratorService.generate(String.format("icon:code:index", new Object[0]), "ICON", null, 1L, 6);
            iconDto.setIconCode(code);
        } else {
            Integer count = this.iconRepository.countByIconCode(iconDto.getIconCode());
            Validate.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u56fe\u6807\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        IconEntity mdmIconEntity = (IconEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)iconDto, IconEntity.class, HashSet.class, LinkedList.class, new String[0]));
        mdmIconEntity.setCreateAccount(this.findCurrentAccount());
        mdmIconEntity.setCreateTime(new Date());
        mdmIconEntity.setModifyAccount(this.findCurrentAccount());
        this.iconRepository.saveAndFlush((Object)mdmIconEntity);
    }

    @Override
    @Transactional
    public void updateByIconDto(IconDto iconDto) {
        Validate.notBlank((CharSequence)iconDto.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)iconDto.getIconCode(), (String)"\u56fe\u6807\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional iconOpt = this.iconRepository.findById(iconDto.getId());
        Validate.isTrue((boolean)iconOpt.isPresent(), (String)"\u56fe\u6807\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List<IconEntity> list = this.iconRepository.findIdByIconCode(iconDto.getIconCode());
        long codeCount = list.stream().filter(x -> !iconDto.getId().equals(x.getId())).count();
        Validate.isTrue((codeCount < 1L ? 1 : 0) != 0, (String)"\u56fe\u6807\u7f16\u7801\u91cd\u590d", (Object[])new Object[0]);
        IconEntity entity = (IconEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)iconDto, IconEntity.class, HashSet.class, LinkedList.class, new String[0]));
        entity.setModifyTime(new Date());
        entity.setModifyAccount(this.findCurrentAccount());
        IconEntity iconDB = (IconEntity)((Object)iconOpt.get());
        entity.setCreateAccount(iconDB.getCreateAccount());
        entity.setCreateTime(iconDB.getCreateTime());
        this.iconRepository.saveAndFlush((Object)entity);
    }

    @Override
    @Transactional
    public void deleteByIdIn(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.iconRepository.deleteByIdIn(ids);
    }

    private String findCurrentAccount() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String account = "admin";
        if (authentication != null) {
            account = authentication.getName();
        }
        return account;
    }
}

