/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.icon.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.icon.local.entity.IconEntity;
import com.bizunited.nebula.icon.local.repository.IconRepository;
import com.bizunited.nebula.icon.sdk.dto.IconPaginationDto;
import com.bizunited.nebula.icon.sdk.service.IconVoService;
import com.bizunited.nebula.icon.sdk.vo.IconVo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IconVoServiceImpl
implements IconVoService {
    @Autowired(required=false)
    private IconRepository iconRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<IconVo> findByCondition(Pageable pageable, IconPaginationDto iconPaginationDto) {
        if (Objects.isNull(iconPaginationDto)) {
            return null;
        }
        Page<IconEntity> page = this.iconRepository.findByCondition(pageable, iconPaginationDto);
        List content = page.getContent();
        if (CollectionUtils.isEmpty((Collection)content)) {
            return new PageImpl((List)Lists.newLinkedList(), pageable, page.getTotalElements());
        }
        List iconVos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)content, IconEntity.class, IconVo.class, HashSet.class, LinkedList.class, new String[0]);
        return new PageImpl(iconVos, pageable, page.getTotalElements());
    }

    public IconVo findByIdOrIconCode(String id, String iconCode) {
        if (StringUtils.isEmpty((CharSequence)id) && StringUtils.isEmpty((CharSequence)iconCode)) {
            return null;
        }
        IconEntity one = this.iconRepository.findByIdOrIconCode(id, iconCode);
        IconVo iconVo = (IconVo)this.nebulaToolkitService.copyObjectByBlankList((Object)one, IconVo.class, HashSet.class, LinkedList.class, new String[0]);
        return iconVo;
    }

    public List<IconVo> findByIconCodeIn(List<String> iconCodes) {
        if (CollectionUtils.isEmpty(iconCodes)) {
            return null;
        }
        List<IconEntity> byIconCodeIn = this.iconRepository.findByIconCodeIn(iconCodes);
        List iconVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(byIconCodeIn, IconEntity.class, IconVo.class, HashSet.class, LinkedList.class, new String[0]);
        return iconVos;
    }
}

