/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.init.service;

import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.init.service.InitProcessEnvironmentService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InitProcessEnvironmentForAppCodeTask {
    @Autowired(required=false)
    private List<InitProcessEnvironmentService> initProcessEnvironmentServices;
    @Autowired
    private RedisMutexService redisMutexService;
    @Value(value="${spring.application.name}")
    private String applicationName;
    private static final Logger LOGGER = LoggerFactory.getLogger(InitProcessEnvironmentForAppCodeTask.class);

    @Async(value="initProcessThreadPoolExecutor")
    public void init(String tenantCode) {
        if (CollectionUtils.isEmpty(this.initProcessEnvironmentServices)) {
            return;
        }
        List<InitProcessEnvironmentService> queue = this.initProcessEnvironmentServices.stream().sorted((t, s) -> t.sort() - s.sort()).collect(Collectors.toList());
        String redisKey = StringUtils.join((Object[])new String[]{"_starting_init", "_", tenantCode, "_", this.applicationName});
        try {
            LOGGER.info("....appcode[{}] init process handing!", (Object)tenantCode);
            this.redisMutexService.lock(redisKey);
            this.init(queue, tenantCode);
            LOGGER.info("....appcode[{}] init process done!", (Object)tenantCode);
        }
        catch (RuntimeException e) {
            LOGGER.info("....appcode[{}] init process error!", (Object)tenantCode);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            this.redisMutexService.unlock(redisKey);
            TenantContextHolder.clean();
        }
    }

    private void init(List<InitProcessEnvironmentService> queue, String tenantCode) {
        for (InitProcessEnvironmentService initProcessService : queue) {
            try {
                boolean doProcess = initProcessService.doInitForAppCode(tenantCode);
                if (!doProcess) continue;
                initProcessService.initForAppCode(tenantCode);
            }
            catch (RuntimeException e) {
                boolean stopOnException = initProcessService.stopOnException();
                if (!stopOnException) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                    continue;
                }
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }
}

