/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.mars.local.service.MarsAuthorityPlusService;
import com.bizunited.nebula.mars.sdk.dto.MarsAuthorityDto;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthority;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="MarsAuthorityController", tags={"\u6570\u636e\u6743\u9650\u57fa\u672c\u4fe1\u606f\u76f8\u5173\u7684http restful\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/mars/authority"})
public class MarsAuthorityController
extends BaseController {
    @Autowired
    private MarsAuthorityPlusService marsAuthorityService;
    private static final Logger LOGGER = LoggerFactory.getLogger(MarsAuthorityController.class);

    @ApiOperation(value="\u6279\u91cf\u91cd\u65b0\u521b\u5efa\u65b0\u7684\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u4e3b\u6570\u636e")
    @PostMapping(value={"/reCreate"})
    public ResponseModel reCreate(@RequestBody Set<MarsAuthorityDto> marsAuthorities) {
        try {
            List<MarsAuthority> results = this.marsAuthorityService.reCreate(marsAuthorities);
            return this.buildHttpResult(results);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u521b\u5efa\u65b0\u7684\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u4e3b\u6570\u636e")
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody MarsAuthorityDto marsAuthority) {
        try {
            MarsAuthority result = this.marsAuthorityService.create(marsAuthority);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u65b0\u7684\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u4e3b\u6570\u636e\uff0c\u4f46\u8bf7\u6ce8\u610f\uff0c\u4fee\u6539\u6570\u636e\u65f6\u5e76\u4e0d\u662f\u6240\u6709\u6570\u636e\u90fd\u80fd\u4fee\u6539\u3002\u4f8b\u5982\u4e1a\u52a1\u7f16\u7801code\u5c31\u4e0d\u80fd\u4fee\u6539\u3002")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestBody MarsAuthorityDto marsAuthority) {
        try {
            MarsAuthority result = this.marsAuthorityService.update(marsAuthority);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u4e00\u4e2a\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u4e3a\u201c\u6709\u6548\u201d\uff08\u53ea\u80fd\u662f\u5f53\u524d\u64cd\u4f5c\u8005\u6240\u5728\u79df\u6237\uff09")
    @PostMapping(value={"/effective"})
    public ResponseModel effective(@RequestParam(value="code") String code) {
        try {
            this.marsAuthorityService.effective(code);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u4e00\u4e2a\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u4e3a\u201c\u65e0\u6548\u201d\uff08\u53ea\u80fd\u662f\u5f53\u524d\u64cd\u4f5c\u8005\u6240\u5728\u79df\u6237\uff09")
    @PostMapping(value={"/invalid"})
    public ResponseModel invalid(@RequestParam(value="code") String code) {
        try {
            this.marsAuthorityService.invalid(code);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u4e1a\u52a1\u7f16\u53f7\u8fdb\u884c\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u7684\u201c\u5220\u9664\u201d\u64cd\u4f5c\uff08\u53ef\u652f\u6301\u5220\u9664\u591a\u4e2a\uff09")
    @DeleteMapping(value={"/deleteByCode"})
    public ResponseModel deleteByCode(@RequestParam(value="code") String[] codes) {
        try {
            for (String code : codes) {
                this.marsAuthorityService.deleteByCode(code);
            }
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u7684\u4e1a\u52a1\u7f16\u53f7\uff0c\u8fdb\u884c\u67d0\u4e2a\u5177\u4f53\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u4fe1\u606f\u7684\u67e5\u8be2\uff08\u5305\u62ec\u5173\u8054\u7684\u4fe1\u606f\uff09")
    @GetMapping(value={"/findByCode"})
    public ResponseModel findByCode(@RequestParam(value="code") String code) {
        try {
            MarsAuthority marsAuthority = this.marsAuthorityService.findDetailByCode(code);
            return this.buildHttpResult(marsAuthority);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u7684\u4e1a\u52a1\u7f16\u53f7\uff0c\u8fdb\u884c\u67d0\u4e2a\u5177\u4f53\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u4fe1\u606f\u7684\u67e5\u8be2\uff08\u5305\u62ec\u5173\u8054\u7684\u4fe1\u606f\uff09")
    @GetMapping(value={"/findByListCode"})
    public ResponseModel findByListCode(@RequestParam(value="listCode", required=false) @ApiParam(name="listCode", value="\u9700\u8981\u8fdb\u884c\u6570\u636e\u6743\u9650\u9650\u5236\u7684\u5217\u8868\u7f16\u53f7") String listCode) {
        try {
            Set marsAuthorities = this.marsAuthorityService.findByListCode(listCode);
            return this.buildHttpResult(marsAuthorities);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684listCode\u5217\u8868\u7f16\u53f7\uff0c\u57fa\u4e8e\u5f53\u524d\u767b\u5f55\u8005\u548c\u4e1a\u52a1\u8303\u56f4\u6ce8\u518c\u5668\uff0c\u6700\u7ec8\u5f97\u5230\u8fd9\u4e2a\u5217\u8868\u53ef\u6b63\u786e\u5339\u914d\u7684\u6570\u636e\u6743\u9650\u4fe1\u606f")
    @GetMapping(value={"/findByListCodeAndCurrentUser"})
    public ResponseModel findByListCodeAndCurrentUser(@RequestParam(value="listCode", required=false) @ApiParam(name="listCode", value="\u9700\u8981\u8fdb\u884c\u6570\u636e\u6743\u9650\u9650\u5236\u7684\u5217\u8868\u7f16\u53f7") String listCode) {
        try {
            Set marsAuthorities = this.marsAuthorityService.findByListCodeAndCurrentUser(listCode);
            return this.buildHttpResultW(marsAuthorities, new String[]{"marsSelectDetails"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

