/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityExpressionService;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthorityExpressionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="MarsAuthorityExpressionController", tags={"\u6570\u636e\u6743\u9650\u57fa\u672c\u4fe1\u606f\u76f8\u5173\u7684http restful\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/mars/expression"})
public class MarsAuthorityExpressionController
extends BaseController {
    @Autowired
    private MarsAuthorityExpressionService marsAuthorityExpressionService;
    private static final Logger LOGGER = LoggerFactory.getLogger(MarsAuthorityExpressionController.class);

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u7684listCode\uff0c\u67e5\u8be2\u5b83\u7684\u8868\u8fbe\u5f0f", notes="\u7531\u4e8e\u7248\u672c\u7ee7\u627f\u7684\u5173\u7cfb\uff0c\u4e00\u4e2alistCode\u5bf9\u5e94\u7684\u5217\u8868\u53ef\u80fd\u8bbe\u5b9a\u4e86\u6570\u636e\u6743\u9650\uff0c\u4f46\u662f\u8fd9\u91cc\u5e76\u6ca1\u6709\u8868\u5355\u5f0f\u4fe1\u606f")
    @GetMapping(value={"/findByListCode"})
    public ResponseModel findByListCode(@RequestParam(value="listCode") String listCode) {
        try {
            MarsAuthorityExpressionVo marsAuthorityExpression = this.marsAuthorityExpressionService.findByListCode(listCode);
            return this.buildHttpResult(marsAuthorityExpression);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4e3a\u6307\u5b9alistCode\uff08\u5217\u8868\u63a7\u4ef6\uff09\u521b\u5efa\u4e00\u4e2a\u591a\u4e2a\u76f8\u5173\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u7684\u7ec4\u5408\u516c\u5f0f")
    @PostMapping
    public ResponseModel create(@RequestBody MarsAuthorityExpressionVo marsAuthorityExpression) {
        try {
            return this.buildHttpResult(this.marsAuthorityExpressionService.create(marsAuthorityExpression));
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4e3a\u6307\u5b9alistCode\uff08\u5217\u8868\u63a7\u4ef6\uff09\u4fee\u6539\u591a\u4e2a\u76f8\u5173\u6570\u636e\u6743\u9650\u8bbe\u5b9a\u7684\u7ec4\u5408\u516c\u5f0f")
    @PatchMapping
    public ResponseModel update(@RequestBody MarsAuthorityExpressionVo marsAuthorityExpression) {
        try {
            this.marsAuthorityExpressionService.update(marsAuthorityExpression);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

