/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.filter;

import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityExcludedFieldDetailService;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class MarsAuthorityRequestFilter
extends OncePerRequestFilter {
    @Autowired
    private MarsAuthorityExcludedFieldDetailService marsAuthorityExcludedFieldDetailService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String urlPatter = "/v1/mars/**";
        AntPathRequestMatcher antPathRequestMatcher = new AntPathRequestMatcher(urlPatter);
        if (antPathRequestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String listCode = this.findHead(request);
        if (StringUtils.isBlank((CharSequence)listCode)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        try {
            marsAuthorityContext.setListCode(listCode);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            Set marsAuthorityCodes = marsAuthorityContext.getMatchedMarsAuthorityCodes();
            MarsAuthorityContextHolder.clearContext();
            if (CollectionUtils.isEmpty((Collection)marsAuthorityCodes)) {
                return;
            }
            Set marsAuthorityExcludedFields = this.marsAuthorityExcludedFieldDetailService.findByMarsAuthorityCodes(marsAuthorityCodes);
            if (CollectionUtils.isEmpty((Collection)marsAuthorityExcludedFields)) {
                return;
            }
            response.setHeader("MARS_AUTHORITY_EXCLUDED_FIELD", StringUtils.join((Iterable)marsAuthorityExcludedFields, (String)","));
        }
    }

    private String findHead(HttpServletRequest request) {
        String marsHeaderName;
        String[] marsNameAry = new String[]{"MARS_LIST_CODE", "mars_list_code", "Mars_List_Code", "Mars_list_code", "MARSLISTCODE", "marslistcode", "MarsListCode", "Marslistcode"};
        String listCode = null;
        String[] stringArray = marsNameAry;
        int n = stringArray.length;
        for (int i = 0; i < n && StringUtils.isBlank((CharSequence)(listCode = request.getHeader(marsHeaderName = stringArray[i]))); ++i) {
        }
        return listCode;
    }
}

