/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.repository.internal;

import com.bizunited.nebula.common.repository.PageRepositoryImpl;
import com.bizunited.nebula.mars.local.entity.MarsAuthorityEntity;
import com.bizunited.nebula.mars.local.repository.internal.MarsAuthorityRepositoryCustom;
import com.bizunited.nebula.mars.local.vo.MarsAuthorityQueryVo;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="MarsAuthorityRepositoryCustomImpl")
public class MarsAuthorityRepositoryCustomImpl
implements MarsAuthorityRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<MarsAuthorityEntity> findByConditions(Pageable pageable, MarsAuthorityQueryVo conditions) {
        String listName;
        String competenceName;
        String name;
        StringBuilder hql = new StringBuilder("from MarsAuthorityEntity dt left join fetch dt.marsSelectDetails dts where 1 = 1");
        StringBuilder countHql = new StringBuilder("select count(*) from MarsAuthorityEntity dt where 1 = 1");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String tenantCode = conditions.getTenantCode();
        condition.append(" AND dt.tenantCode = :tenantCode ");
        parameters.put("tenantCode", tenantCode);
        String code = conditions.getCode();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            condition.append(" AND dt.code = :code ");
            parameters.put("code", code);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = conditions.getName()))) {
            condition.append(" AND dt.name like CONCAT('%',:name,'%') ");
            parameters.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)(competenceName = conditions.getCompetenceName()))) {
            condition.append(" AND dt.competenceName like CONCAT('%',:competenceName,'%') ");
            parameters.put("competenceName", competenceName);
        }
        if (StringUtils.isNotBlank((CharSequence)(listName = conditions.getListName()))) {
            condition.append(" AND dt.listName like CONCAT('%',:listName,'%') ");
            parameters.put("listName", listName);
        }
        Boolean defaultScope = conditions.getDefaultScope();
        if (conditions.getDefaultScope() != null) {
            condition.append(" AND dt.defaultScope = :defaultScope ");
            parameters.put("defaultScope", defaultScope);
        }
        hql.append((CharSequence)condition).append(" order by dt.createTime desc ");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }
}

