/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.service.helper;

import com.bizunited.nebula.mars.local.vo.MarsExpressionOperatorVo;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.enums.MarsAuthorityOperatorTypeEnum;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthorityExpressionVo;
import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeRegisterVo;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MarsAuthorityServiceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarsAuthorityServiceHelper.class);

    public MarsExpressionOperatorVo buildExpressionOperator(MarsAuthorityContext marsAuthorityContext, Map<String, Set<SelectAuthorityModeRegisterVo>> selectAuthorityModeValueMapping, MarsAuthorityExpressionVo marsAuthorityExpressionVo) {
        Set marsAuthorityCodes = marsAuthorityContext.getMatchedMarsAuthorityCodes();
        MarsExpressionOperatorVo marsExpressionOperatorVo = new MarsExpressionOperatorVo();
        marsExpressionOperatorVo.setModeRegisterList(Lists.newArrayList());
        marsExpressionOperatorVo.setChildrenList(Lists.newArrayList());
        if (marsAuthorityExpressionVo == null || marsAuthorityExpressionVo.getExpressionType() == null) {
            marsExpressionOperatorVo.setOperatorType(MarsAuthorityOperatorTypeEnum.AND.getType());
        } else if (Objects.equals(marsAuthorityExpressionVo.getExpressionType(), MarsAuthorityOperatorTypeEnum.AND.getType()) || Objects.equals(marsAuthorityExpressionVo.getExpressionType(), MarsAuthorityOperatorTypeEnum.OR.getType())) {
            marsExpressionOperatorVo.setOperatorType(marsAuthorityExpressionVo.getExpressionType());
        } else {
            LOGGER.warn("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6743\u9650\u8868\u8fbe\u516c\u5f0f\u7c7b\u578b:{}, \u8bf7\u68c0\u67e5!", (Object)marsAuthorityExpressionVo.getExpressionType());
            return marsExpressionOperatorVo;
        }
        for (String marsAuthorityCode : marsAuthorityCodes) {
            this.buildExpressionOperatorModeRegister(marsAuthorityCode, selectAuthorityModeValueMapping, marsExpressionOperatorVo);
        }
        return marsExpressionOperatorVo;
    }

    private void buildExpressionOperatorModeRegister(String marsAuthorityCode, Map<String, Set<SelectAuthorityModeRegisterVo>> selectAuthorityModeValueMapping, MarsExpressionOperatorVo marsExpressionOperatorVo) {
        Set<SelectAuthorityModeRegisterVo> modeRegisterVos = selectAuthorityModeValueMapping.get(marsAuthorityCode);
        if (CollectionUtils.isEmpty(modeRegisterVos)) {
            LOGGER.warn("\u6570\u636e\u6743\u9650[{}], \u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u6388\u6743\u7eac\u5ea6, \u8bf7\u68c0\u67e5!", (Object)marsAuthorityCode);
            return;
        }
        if (modeRegisterVos.size() == 1) {
            marsExpressionOperatorVo.getModeRegisterList().addAll(modeRegisterVos);
            return;
        }
        MarsExpressionOperatorVo childrenOperatorVo = new MarsExpressionOperatorVo();
        childrenOperatorVo.setOperatorType(MarsAuthorityOperatorTypeEnum.AND.getType());
        childrenOperatorVo.setModeRegisterList(Lists.newArrayList(modeRegisterVos));
        marsExpressionOperatorVo.getChildrenList().add(childrenOperatorVo);
    }
}

