/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.mars.local.entity.MarsAuthorityEntity;
import com.bizunited.nebula.mars.local.entity.MarsAuthorityExpressionEntity;
import com.bizunited.nebula.mars.local.repository.MarsAuthorityExpressionRepository;
import com.bizunited.nebula.mars.local.repository.MarsAuthorityRepository;
import com.bizunited.nebula.mars.sdk.event.MarsAuthorityExpressionEventListener;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityExpressionService;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthorityExpressionVo;
import com.bizunited.nebula.security.sdk.AuthenticationUserService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MarsAuthorityExpressionServiceImpl
implements MarsAuthorityExpressionService {
    @Autowired
    private MarsAuthorityExpressionRepository marsAuthorityExpressionRepository;
    @Autowired
    private MarsAuthorityRepository marsAuthorityRepository;
    @Autowired
    private AuthenticationUserService authenticationUserService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<MarsAuthorityExpressionEventListener> eventListeners;

    public MarsAuthorityExpressionVo findByListCode(String listCode) {
        if (StringUtils.isBlank((CharSequence)listCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        MarsAuthorityExpressionEntity marsAuthorityExpression = this.marsAuthorityExpressionRepository.findByTenantCodeAndListCode(tenantCode, listCode);
        if (marsAuthorityExpression == null) {
            return null;
        }
        return (MarsAuthorityExpressionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)marsAuthorityExpression, MarsAuthorityExpressionVo.class, LinkedHashSet.class, LinkedList.class, new String[]{""});
    }

    @Transactional
    public MarsAuthorityExpressionVo create(MarsAuthorityExpressionVo marsAuthorityExpression) {
        Validate.notNull((Object)marsAuthorityExpression, (String)"\u8fdb\u884c\u516c\u5f0f\u4fe1\u606f\u521b\u5efa\u65f6\uff0c\u9700\u4f20\u5165\u503c", (Object[])new Object[0]);
        String expression = marsAuthorityExpression.getExpression();
        Integer expressionType = marsAuthorityExpression.getExpressionType();
        String listCode = marsAuthorityExpression.getListCode();
        Validate.notBlank((CharSequence)listCode, (String)"\u6307\u5b9a\u7684\u5217\u8868\uff08\u63a7\u4ef6\uff09\u7f16\u7801\u5fc5\u987b\u4f20\u5165\uff08listCode\uff09", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        MarsAuthorityExpressionEntity currentMarsAuthorityExpression = this.marsAuthorityExpressionRepository.findByTenantCodeAndListCode(tenantCode, listCode);
        Validate.isTrue((currentMarsAuthorityExpression == null ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u5217\u8868\uff08\u63a7\u4ef6\uff09\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u516c\u5f0f\uff0c\u60a8\u53ef\u4ee5\u8fdb\u884c\u516c\u5f0f\u4fee\u6539\uff0c\u4f46\u662f\u4e0d\u80fd\u91cd\u590d\u521b\u5efa", (Object[])new Object[0]);
        Set<MarsAuthorityEntity> marsAuthorityEntities = this.marsAuthorityRepository.findByListCodeAndTenantCodeAndDefaultScope(listCode, tenantCode, false);
        Validate.isTrue((!CollectionUtils.isEmpty(marsAuthorityEntities) ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u5217\u8868\uff08\u63a7\u4ef6\uff09\u5e76\u6ca1\u6709\u8bbe\u7f6e\u4efb\u4f55\u6570\u636e\u6743\u9650\uff08\u9ed8\u8ba4\u7684\u4e0d\u7b97\uff09\uff0c\u8bf7\u5148\u8bbe\u5b9a\u6570\u636e\u6743\u9650\uff0c\u518d\u8bbe\u5b9a\u516c\u5f0f", (Object[])new Object[0]);
        Validate.notNull((Object)expressionType, (String)"\u6307\u5b9a\u7684\u516c\u5f0f\u7c7b\u578b\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)3L, (long)expressionType.intValue(), (String)"\u516c\u5f0f\u7c7b\u578b\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5");
        if (expressionType == 3) {
            Validate.notBlank((CharSequence)expression, (String)"\u81ea\u5b9a\u4e49\u516c\u5f0f\u4fe1\u606f\u5fc5\u987b\u8bbe\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        } else {
            expression = "";
        }
        String account = this.authenticationUserService.findCurrentAccount();
        Date time = new Date();
        MarsAuthorityExpressionEntity marsAuthorityExpressionEntity = new MarsAuthorityExpressionEntity();
        marsAuthorityExpressionEntity.setCreateAccount(account);
        marsAuthorityExpressionEntity.setCreateTime(time);
        marsAuthorityExpressionEntity.setModifyAccount(account);
        marsAuthorityExpressionEntity.setModifyTime(time);
        marsAuthorityExpressionEntity.setExpression(expression);
        marsAuthorityExpressionEntity.setExpressionType(expressionType);
        marsAuthorityExpressionEntity.setListCode(listCode);
        marsAuthorityExpressionEntity.setTenantCode(tenantCode);
        marsAuthorityExpressionEntity.setSelectTableNames(marsAuthorityExpression.getSelectTableNames());
        this.marsAuthorityExpressionRepository.save((Object)marsAuthorityExpressionEntity);
        MarsAuthorityExpressionVo marsAuthorityExpressionVo = (MarsAuthorityExpressionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)marsAuthorityExpressionEntity, MarsAuthorityExpressionVo.class, LinkedHashSet.class, LinkedList.class, new String[]{""});
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            MarsAuthorityEntity marsAuthorityEntity = (MarsAuthorityEntity)((Object)Lists.newArrayList(marsAuthorityEntities).get(0));
            marsAuthorityExpressionVo.setMarsAuthorityId(marsAuthorityEntity.getId());
            this.eventListeners.forEach(eventListener -> eventListener.onCreated(marsAuthorityExpressionVo));
        }
        return marsAuthorityExpressionVo;
    }

    @Transactional
    public void update(MarsAuthorityExpressionVo marsAuthorityExpression) {
        Set<MarsAuthorityEntity> marsAuthorityEntities;
        Validate.notNull((Object)marsAuthorityExpression, (String)"\u8fdb\u884c\u516c\u5f0f\u4fe1\u606f\u4fee\u6539\u65f6\uff0c\u9700\u4f20\u5165\u503c", (Object[])new Object[0]);
        String id = marsAuthorityExpression.getId();
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u516c\u5f0f\u4fe1\u606f\u4fee\u6539\u65f6\uff0cid\u7f16\u53f7\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String expression = marsAuthorityExpression.getExpression();
        Integer expressionType = marsAuthorityExpression.getExpressionType();
        String listCode = marsAuthorityExpression.getListCode();
        MarsAuthorityExpressionEntity currentMarsAuthorityExpression = this.marsAuthorityExpressionRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)currentMarsAuthorityExpression), (String)"\u8fdb\u884c\u516c\u5f0f\u4fe1\u606f\u4fee\u6539\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u516c\u5f0f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)listCode, (CharSequence)currentMarsAuthorityExpression.getListCode()), (String)"\u4fee\u6539\u516c\u5f0f\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u5217\u8868\uff08\u63a7\u4ef6\uff09\u7f16\u53f7listCode\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)expressionType, (String)"\u6307\u5b9a\u7684\u516c\u5f0f\u7c7b\u578b\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)3L, (long)expressionType.intValue(), (String)"\u516c\u5f0f\u7c7b\u578b\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5");
        if (expressionType == 3) {
            Validate.notBlank((CharSequence)expression, (String)"\u81ea\u5b9a\u4e49\u516c\u5f0f\u4fe1\u606f\u5fc5\u987b\u8bbe\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        } else {
            expression = "";
        }
        MarsAuthorityExpressionVo oldMarsAuthorityExpression = (MarsAuthorityExpressionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentMarsAuthorityExpression, MarsAuthorityExpressionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        String account = this.authenticationUserService.findCurrentAccount();
        Date time = new Date();
        currentMarsAuthorityExpression.setModifyAccount(account);
        currentMarsAuthorityExpression.setModifyTime(time);
        currentMarsAuthorityExpression.setExpression(expression);
        currentMarsAuthorityExpression.setExpressionType(expressionType);
        currentMarsAuthorityExpression.setSelectTableNames(marsAuthorityExpression.getSelectTableNames());
        this.marsAuthorityExpressionRepository.save((Object)currentMarsAuthorityExpression);
        if (!CollectionUtils.isEmpty(this.eventListeners) && CollectionUtils.isEmpty(marsAuthorityEntities = this.marsAuthorityRepository.findByListCodeAndTenantCodeAndDefaultScope(listCode, TenantUtils.getTenantCode(), false))) {
            MarsAuthorityExpressionEntity expressionEntity = this.marsAuthorityExpressionRepository.findById(id).orElse(null);
            MarsAuthorityExpressionVo newMarsAuthorityExpression = (MarsAuthorityExpressionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)expressionEntity, MarsAuthorityExpressionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            MarsAuthorityEntity marsAuthorityEntity = (MarsAuthorityEntity)((Object)Lists.newArrayList(marsAuthorityEntities).get(0));
            newMarsAuthorityExpression.setMarsAuthorityId(marsAuthorityEntity.getId());
            oldMarsAuthorityExpression.setMarsAuthorityId(marsAuthorityEntity.getId());
            this.eventListeners.forEach(eventListener -> eventListener.onUpdate(oldMarsAuthorityExpression, newMarsAuthorityExpression));
        }
    }
}

