/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.service.internal;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeGroupRegister;
import com.bizunited.nebula.mars.sdk.service.SelectAuthorityModeGroupRegisterService;
import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeGroupRegisterVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Lazy
@Component(value="selectAuthorityModeGroupRegisterService")
public class SelectAuthorityModeGroupRegisterServiceImpl
implements SelectAuthorityModeGroupRegisterService {
    @Autowired(required=false)
    @Lazy
    private List<SelectAuthorityModeGroupRegister> selectAuthorityModeGroupRegisters;

    public SelectAuthorityModeGroupRegisterVo findByGroupCode(String groupCode) {
        if (StringUtils.isBlank((CharSequence)groupCode) || CollectionUtils.isEmpty(this.selectAuthorityModeGroupRegisters)) {
            return null;
        }
        for (SelectAuthorityModeGroupRegister selectAuthorityModeGroupRegister : this.selectAuthorityModeGroupRegisters) {
            String currentGroupCode = selectAuthorityModeGroupRegister.groupCode();
            if (!StringUtils.equals((CharSequence)currentGroupCode, (CharSequence)groupCode)) continue;
            return this.build(selectAuthorityModeGroupRegister);
        }
        return null;
    }

    public List<SelectAuthorityModeGroupRegisterVo> findByGroupCodes(String[] groupCodes) {
        if (groupCodes == null || groupCodes.length == 0 || CollectionUtils.isEmpty(this.selectAuthorityModeGroupRegisters)) {
            return null;
        }
        HashSet groupCodeSet = Sets.newHashSet((Object[])groupCodes);
        ArrayList result = Lists.newArrayList();
        block0: for (String groupCode : groupCodeSet) {
            for (SelectAuthorityModeGroupRegister selectAuthorityModeGroupRegister : this.selectAuthorityModeGroupRegisters) {
                String currentGroupCode = selectAuthorityModeGroupRegister.groupCode();
                if (!StringUtils.equals((CharSequence)currentGroupCode, (CharSequence)groupCode)) continue;
                result.add(this.build(selectAuthorityModeGroupRegister));
                continue block0;
            }
        }
        return result;
    }

    private SelectAuthorityModeGroupRegisterVo build(SelectAuthorityModeGroupRegister selectAuthorityModeGroupRegister) {
        String groupCode = selectAuthorityModeGroupRegister.groupCode();
        String groupName = selectAuthorityModeGroupRegister.groupName();
        Set viewFieldNames = selectAuthorityModeGroupRegister.viewFieldNames();
        Set repositoryFieldNames = selectAuthorityModeGroupRegister.repositoryFieldNames();
        Boolean defaultGroup = selectAuthorityModeGroupRegister.defaultGroup();
        defaultGroup = defaultGroup == null ? false : defaultGroup;
        SelectAuthorityModeGroupRegisterVo selectAuthorityModeGroupRegisterVo = new SelectAuthorityModeGroupRegisterVo();
        selectAuthorityModeGroupRegisterVo.setGroupCode(groupCode);
        selectAuthorityModeGroupRegisterVo.setGroupName(groupName);
        selectAuthorityModeGroupRegisterVo.setRepositoryFieldNames(repositoryFieldNames);
        selectAuthorityModeGroupRegisterVo.setViewFieldNames(viewFieldNames);
        selectAuthorityModeGroupRegisterVo.setDefaultGroup(defaultGroup);
        return selectAuthorityModeGroupRegisterVo;
    }

    public List<SelectAuthorityModeGroupRegisterVo> findByViewFieldNames(String[] viewFiledNames, Boolean includeDefault) {
        if (viewFiledNames == null || viewFiledNames.length == 0) {
            return null;
        }
        HashSet sourceViewFiledNames = Sets.newHashSet((Object[])viewFiledNames);
        List<Object> results = Lists.newArrayList();
        for (SelectAuthorityModeGroupRegister selectAuthorityModeGroupRegister : this.selectAuthorityModeGroupRegisters) {
            Set targetViewFieldNames = selectAuthorityModeGroupRegister.viewFieldNames();
            if (CollectionUtils.isEmpty((Collection)targetViewFieldNames) || Sets.intersection((Set)sourceViewFiledNames, (Set)targetViewFieldNames).isEmpty()) continue;
            results.add(this.build(selectAuthorityModeGroupRegister));
        }
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        if (includeDefault == null || !includeDefault.booleanValue()) {
            results = results.stream().filter(item -> item.getDefaultGroup() == false).collect(Collectors.toList());
        }
        return results;
    }
}

