/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.service.internal;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityService;
import com.bizunited.nebula.mars.sdk.service.SelectAuthorityModeRegisterService;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthority;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthorityDetail;
import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeRegisterVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Lazy
@Component(value="selectAuthorityModeRegisterService")
public class SelectAuthorityModeRegisterServiceImpl
implements SelectAuthorityModeRegisterService {
    @Autowired(required=false)
    @Lazy
    private List<SelectAuthorityModeRegister> selectAuthorityModeRegisters;
    @Autowired
    private MarsAuthorityService marsAuthorityService;
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectAuthorityModeRegisterServiceImpl.class);

    public List<SelectAuthorityModeRegisterVo> findByGroupCode(String groupCode) {
        if (StringUtils.isBlank((CharSequence)groupCode) || CollectionUtils.isEmpty(this.selectAuthorityModeRegisters)) {
            return Lists.newArrayList();
        }
        List<Object> resutls = Lists.newArrayList();
        for (SelectAuthorityModeRegister selectAuthorityModeRegister : this.selectAuthorityModeRegisters) {
            String selectedGroupCode = selectAuthorityModeRegister.groupCode();
            if (StringUtils.isBlank((CharSequence)selectedGroupCode) || !StringUtils.equals((CharSequence)selectedGroupCode, (CharSequence)groupCode)) continue;
            SelectAuthorityModeRegisterVo vo = this.build(selectAuthorityModeRegister);
            resutls.add(vo);
        }
        resutls = resutls.stream().sorted((source, target) -> source.getSort() - target.getSort()).collect(Collectors.toList());
        return resutls;
    }

    private SelectAuthorityModeRegisterVo build(SelectAuthorityModeRegister selectAuthorityModeRegister) {
        String currentModeKey = selectAuthorityModeRegister.modeKey();
        String modeName = selectAuthorityModeRegister.modeName();
        String controlKey = selectAuthorityModeRegister.controlKey();
        int sort = selectAuthorityModeRegister.sort();
        Class modeValueClass = selectAuthorityModeRegister.modeValueClass();
        String modeValueClassString = modeValueClass.getName();
        String groupCode = selectAuthorityModeRegister.groupCode();
        boolean isArrayValue = selectAuthorityModeRegister.isArrayValue();
        boolean isStaticValue = selectAuthorityModeRegister.isStaticValue();
        String converterKey = selectAuthorityModeRegister.converterKey();
        SelectAuthorityModeRegisterVo selectAuthorityModeRegisterVo = new SelectAuthorityModeRegisterVo();
        selectAuthorityModeRegisterVo.setControlKey(controlKey);
        selectAuthorityModeRegisterVo.setGroupCode(groupCode);
        selectAuthorityModeRegisterVo.setModeValueClass(modeValueClassString);
        selectAuthorityModeRegisterVo.setModeKey(currentModeKey);
        selectAuthorityModeRegisterVo.setModeName(modeName);
        selectAuthorityModeRegisterVo.setSort(sort);
        selectAuthorityModeRegisterVo.setArrayValue(Boolean.valueOf(isArrayValue));
        selectAuthorityModeRegisterVo.setStaticValue(Boolean.valueOf(isStaticValue));
        selectAuthorityModeRegisterVo.setConverterKey(converterKey);
        return selectAuthorityModeRegisterVo;
    }

    private SelectAuthorityModeRegisterVo buildWithValue(SelectAuthorityModeRegister selectAuthorityModeRegister, String[] selectModeValues) {
        SelectAuthorityModeRegisterVo vo = this.build(selectAuthorityModeRegister);
        if (vo == null) {
            return null;
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        Object authenticationDetails = authentication.getDetails();
        if (authenticationDetails == null || !(authenticationDetails instanceof UserIdentity)) {
            LOGGER.warn("\u81f3\u5c11\u53d1\u73b0\u4e00\u7ec4marsAuthority\u6570\u636e\u6743\u9650\u4e2d\uff0c\u6ca1\u6709\u6b63\u786e\u83b7\u53d6\u7528\u6237\u8eab\u4efd\u6807\u8bc6UserIdentity");
            vo.setModeValue(null);
            vo.setModeValueClass(null);
            return vo;
        }
        UserIdentity loginDetails = (UserIdentity)authenticationDetails;
        Boolean isArrayValue = vo.getArrayValue();
        String selectModeGroupCode = vo.getGroupCode();
        String selectModeKey = vo.getModeKey();
        String modeValueClassString = vo.getModeValueClass();
        if (StringUtils.isBlank((CharSequence)modeValueClassString)) {
            LOGGER.warn("\u81f3\u5c11\u53d1\u73b0\u4e00\u7ec4marsAuthority\u6570\u636e\u6743\u9650\u4e2d\uff0cmodeValueClass\u503c\u7c7b\u578b\u4fe1\u606f\u8bbe\u5b9a\u4e3anull");
            vo.setModeValue(null);
            vo.setModeValueClass(null);
            return vo;
        }
        Class<?> modeValueClass = null;
        try {
            modeValueClass = Class.forName(modeValueClassString);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("\u81f3\u5c11\u53d1\u73b0\u4e00\u7ec4marsAuthority\u6570\u636e\u6743\u9650\u4e2d\uff0cmodeValueClass\u503c\u7c7b\u578b\u4fe1\u606f\u672a\u88ab\u5b9a\u4f4d");
            vo.setModeValue(null);
            vo.setModeValueClass(null);
            return vo;
        }
        String converterKey = vo.getConverterKey();
        if (StringUtils.isBlank((CharSequence)selectModeGroupCode)) {
            LOGGER.warn("\u81f3\u5c11\u53d1\u73b0\u4e00\u7ec4marsAuthority\u6570\u636e\u6743\u9650\u4e2d\uff0cgroupCode\u5206\u7ec4\u4fe1\u606f\u8bbe\u5b9a\u4e3anull");
            vo.setModeValue(null);
            vo.setModeValueClass(null);
            return vo;
        }
        if (StringUtils.isBlank((CharSequence)selectModeKey)) {
            LOGGER.warn("\u81f3\u5c11\u53d1\u73b0\u4e00\u7ec4marsAuthority\u6570\u636e\u6743\u9650\u4e2d\uff0cmodeKey\u6570\u636e\u9879\u4fe1\u606f\u8bbe\u5b9a\u4e3anull");
            vo.setModeValue(null);
            vo.setModeValueClass(null);
            return vo;
        }
        if (StringUtils.isBlank((CharSequence)converterKey)) {
            LOGGER.warn("\u81f3\u5c11\u53d1\u73b0\u4e00\u7ec4marsAuthority\u6570\u636e\u6743\u9650\u4e2d\uff0cconverterKey\u8f6c\u6362\u5668\u4fe1\u606f\u8bbe\u5b9a\u4e3anull");
            vo.setModeValue(null);
            vo.setModeValueClass(null);
            return vo;
        }
        Object value = null;
        Boolean isStaticValue = vo.getStaticValue();
        value = isStaticValue != false && selectModeValues != null ? selectAuthorityModeRegister.staticValue(selectModeValues) : selectAuthorityModeRegister.dynamicValue(loginDetails, selectModeGroupCode);
        if (value == null) {
            vo.setModeValue(null);
            vo.setModeValueClass(null);
            return vo;
        }
        Class<?> sourceClass = null;
        if (!vo.getArrayValue().booleanValue() && !modeValueClass.isAssignableFrom(sourceClass = value.getClass())) {
            LOGGER.warn("\u6570\u636e\u6743\u9650\u9009\u9879\uff08{}\uff09, \u5176\u8fd4\u56de\u503c\u4e0e\u8be5\u6ce8\u518c\u5668\u8bbe\u5b9a\u7684modeValueClass\u3001isArrayValue\u76f8\u51b2\u7a81\uff0c\u8bf7\u68c0\u67e5", (Object)selectModeKey);
            vo.setModeValue(null);
            vo.setModeValueClass(null);
            return vo;
        }
        if (isArrayValue.booleanValue()) {
            Class<?> arrayClass = value.getClass();
            Class<?> componentClass = arrayClass.getComponentType();
            sourceClass = componentClass;
            if (componentClass == null || !modeValueClass.isAssignableFrom(componentClass)) {
                LOGGER.warn("\u6570\u636e\u6743\u9650\u9009\u9879\uff08{}\uff09, \u5176\u8fd4\u56de\u503c\u4e0e\u8be5\u6ce8\u518c\u5668\u8bbe\u5b9a\u7684modeValueClass\u3001isArrayValue\u76f8\u51b2\u7a81\uff0c\u8bf7\u68c0\u67e5(\u6570\u7ec4)", (Object)selectModeKey);
                vo.setModeValue(null);
                vo.setModeValueClass(null);
                return vo;
            }
        }
        vo.setModeValue(value);
        vo.setModeValueClass(sourceClass.getName());
        return vo;
    }

    private SelectAuthorityModeRegister findRegisterByModeKey(String modeKey) {
        if (StringUtils.isBlank((CharSequence)modeKey) || CollectionUtils.isEmpty(this.selectAuthorityModeRegisters)) {
            return null;
        }
        for (SelectAuthorityModeRegister selectAuthorityModeRegister : this.selectAuthorityModeRegisters) {
            String currentModeKey = selectAuthorityModeRegister.modeKey();
            if (!StringUtils.equals((CharSequence)currentModeKey, (CharSequence)modeKey)) continue;
            return selectAuthorityModeRegister;
        }
        return null;
    }

    public SelectAuthorityModeRegisterVo findByModeKey(String modeKey) {
        SelectAuthorityModeRegister selectAuthorityModeRegister = this.findRegisterByModeKey(modeKey);
        if (selectAuthorityModeRegister == null) {
            return null;
        }
        return this.build(selectAuthorityModeRegister);
    }

    public Map<String, Set<SelectAuthorityModeRegisterVo>> findByAuthorityCodes(Set<String> marsAuthorityCodes) {
        if (CollectionUtils.isEmpty(marsAuthorityCodes)) {
            return null;
        }
        LinkedHashMap mappedMarsAuthorityDetail = Maps.newLinkedHashMap();
        for (String marsAuthorityCode : marsAuthorityCodes) {
            Set marsAuthorityDetails;
            MarsAuthority currentMarsAuthority = this.marsAuthorityService.findDetailByCode(marsAuthorityCode);
            if (currentMarsAuthority == null || CollectionUtils.isEmpty((Collection)(marsAuthorityDetails = currentMarsAuthority.getMarsSelectDetails()))) continue;
            LinkedHashSet mappedSelectModes = Sets.newLinkedHashSet();
            for (MarsAuthorityDetail marsAuthorityDetail : marsAuthorityDetails) {
                String selectModeGroupCode = marsAuthorityDetail.getSelectModeGroupCode();
                String selectModeKey = marsAuthorityDetail.getSelectModeKey();
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{selectModeKey, selectModeGroupCode})) continue;
                String[] selectModeValues = marsAuthorityDetail.getSelectModeValues();
                SelectAuthorityModeRegister selectAuthorityModeRegister = this.findRegisterByModeKey(selectModeKey);
                if (selectAuthorityModeRegister == null) continue;
                SelectAuthorityModeRegisterVo selectAuthorityModeRegisterVo = this.buildWithValue(selectAuthorityModeRegister, selectModeValues);
                mappedSelectModes.add(selectAuthorityModeRegisterVo);
            }
            if (CollectionUtils.isEmpty((Collection)mappedSelectModes)) continue;
            mappedMarsAuthorityDetail.put(marsAuthorityCode, mappedSelectModes);
        }
        return mappedMarsAuthorityDetail;
    }
}

