/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.strategy;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.bizunited.nebula.common.enums.DatabaseType;
import com.bizunited.nebula.common.repository.interceptor.NebulaRepositoryInterceptorStrategy;
import com.bizunited.nebula.common.repository.interceptor.SqlCommandType;
import com.bizunited.nebula.mars.local.configuration.MarsAuthorityProperties;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.bizunited.nebula.mars.sdk.converter.MarsAuthorityAstConverter;
import com.bizunited.nebula.mars.sdk.converter.MarsAuthoritySqlConverter;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityExpressionService;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityService;
import com.bizunited.nebula.mars.sdk.service.SelectAuthorityModeGroupRegisterService;
import com.bizunited.nebula.mars.sdk.service.SelectAuthorityModeRegisterService;
import com.bizunited.nebula.mars.sdk.utils.MarsMybatisSqlUtils;
import com.bizunited.nebula.mars.sdk.vo.DatabaseTableNode;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthority;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthorityExpressionVo;
import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeGroupRegisterVo;
import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeRegisterVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Lazy
@Component
public class MarsAuthorityRepositoryInterceptorStrategy
implements NebulaRepositoryInterceptorStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarsAuthorityRepositoryInterceptorStrategy.class);
    @Autowired
    private MarsAuthorityService marsAuthorityService;
    @Autowired
    private SelectAuthorityModeRegisterService selectAuthorityModeRegisterService;
    @Autowired
    private SelectAuthorityModeGroupRegisterService selectAuthorityModeGroupRegisterService;
    @Autowired
    private MarsAuthorityExpressionService marsAuthorityExpressionService;
    @Autowired(required=false)
    private List<MarsAuthorityAstConverter> marsAuthorityValueAstConverters;
    @Autowired(required=false)
    private List<MarsAuthoritySqlConverter> marsAuthoritySqlConverters;
    @Autowired
    private MarsAuthorityProperties marsAuthorityProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(SqlCommandType sqlCommandType, String sourceSql, Connection currentConnection) {
        String selectTableNames;
        HashSet pointTableNames;
        String[] ignoreTableNames;
        if (sqlCommandType != SqlCommandType.SELECT) {
            return sourceSql;
        }
        DatabaseType databaseType = null;
        try {
            String databaseProduectName = currentConnection.getMetaData().getDatabaseProductName();
            String upperDatabaseProductName = databaseProduectName.toUpperCase();
            databaseType = DatabaseType.valueOfByDesc((String)upperDatabaseProductName);
            if (databaseType == null) {
                return sourceSql;
            }
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return sourceSql;
        }
        if (CollectionUtils.isEmpty(this.marsAuthorityValueAstConverters)) {
            return sourceSql;
        }
        MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        String listCode = marsAuthorityContext.getListCode();
        if (StringUtils.isBlank((CharSequence)listCode)) {
            return sourceSql;
        }
        if (marsAuthorityContext.building().booleanValue()) {
            return sourceSql;
        }
        for (String ignoreTableName : ignoreTableNames = this.marsAuthorityProperties.getIgnoreTableNames()) {
            if (StringUtils.indexOfIgnoreCase((CharSequence)sourceSql, (CharSequence)ignoreTableName) == -1) continue;
            return sourceSql;
        }
        MarsAuthoritySqlConverter selectedMarsAuthoritySqlConverter = null;
        SQLSelectStatement sqlSelectStatement = null;
        for (MarsAuthoritySqlConverter marsAuthoritySqlConverter : this.marsAuthoritySqlConverters) {
            if (!marsAuthoritySqlConverter.support(databaseType)) continue;
            selectedMarsAuthoritySqlConverter = marsAuthoritySqlConverter;
            sqlSelectStatement = (SQLSelectStatement)marsAuthoritySqlConverter.converter(sourceSql, databaseType);
            break;
        }
        if (sqlSelectStatement == null) {
            return sourceSql;
        }
        SQLSelect sqlSelect = sqlSelectStatement.getSelect();
        SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
        MarsAuthorityExpressionVo marsAuthorityExpressionVo = this.marsAuthorityExpressionService.findByListCode(listCode);
        HashSet simpleTableNodes = Sets.newHashSet();
        this.analysisSimpleTableNodes(sqlSelectQuery, simpleTableNodes, sqlSelectQuery.getFrom());
        Set sqlTableNames = simpleTableNodes.stream().map(tableNode -> StringUtils.isNotBlank((CharSequence)tableNode.getAlias()) ? tableNode.getAlias() : tableNode.getTableName()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(sqlTableNames)) {
            return sourceSql;
        }
        if (Objects.nonNull(marsAuthorityExpressionVo) && StringUtils.isNotBlank((CharSequence)marsAuthorityExpressionVo.getSelectTableNames()) && !(pointTableNames = Sets.newHashSet((Object[])(selectTableNames = marsAuthorityExpressionVo.getSelectTableNames()).split(","))).equals(sqlTableNames)) {
            return sourceSql;
        }
        boolean isOwner = false;
        boolean isDefaultAuthority = false;
        try {
            Object object;
            Map selectAuthorityModeValueMapping;
            Object defaultScope;
            Set<Object> marsAuthorityCodes = Sets.newLinkedHashSet();
            if (!marsAuthorityContext.building().booleanValue()) {
                isOwner = true;
                marsAuthorityContext.setBuilding(Boolean.valueOf(isOwner));
            }
            if (CollectionUtils.isEmpty((Collection)(marsAuthorityCodes = marsAuthorityContext.getMatchedMarsAuthorityCodes()))) {
                Set matchedMarsAuthoritys = this.marsAuthorityService.findByListCodeAndCurrentUser(listCode);
                if (CollectionUtils.isEmpty((Collection)matchedMarsAuthoritys)) {
                    String string = sourceSql;
                    return string;
                }
                if (matchedMarsAuthoritys.size() == 1 && (defaultScope = ((MarsAuthority)matchedMarsAuthoritys.iterator().next()).getDefaultScope()) != null && ((Boolean)defaultScope).booleanValue()) {
                    isDefaultAuthority = true;
                }
                marsAuthorityCodes = matchedMarsAuthoritys.stream().filter(item -> item.getStatus() == 1).map(MarsAuthority::getCode).distinct().collect(Collectors.toSet());
                marsAuthorityContext.setMatchedMarsAuthorityCodes((Set)marsAuthorityCodes);
                marsAuthorityContext.setMatchedMarsAuthoritys(matchedMarsAuthoritys);
            }
            if (CollectionUtils.isEmpty((Map)(selectAuthorityModeValueMapping = this.selectAuthorityModeRegisterService.findByAuthorityCodes((Set)marsAuthorityCodes)))) {
                defaultScope = sourceSql;
                return defaultScope;
            }
            String marsAuthorityExpression = "";
            if (isDefaultAuthority) {
                marsAuthorityExpression = marsAuthorityExpression + "[Authority_" + (String)marsAuthorityCodes.iterator().next() + "]";
            } else if (marsAuthorityExpressionVo == null || marsAuthorityExpressionVo.getExpressionType() == null || marsAuthorityExpressionVo.getExpressionType() != 3) {
                int index = 0;
                for (String string : marsAuthorityCodes) {
                    if (index++ != 0) {
                        marsAuthorityExpression = marsAuthorityExpressionVo == null || marsAuthorityExpressionVo.getExpressionType() == null || marsAuthorityExpressionVo.getExpressionType() == 1 ? marsAuthorityExpression + " AND " : marsAuthorityExpression + " OR ";
                    }
                    marsAuthorityExpression = marsAuthorityExpression + "[Authority_" + string + "]";
                }
            } else {
                marsAuthorityExpression = marsAuthorityExpressionVo.getExpression();
            }
            LinkedHashMap mappedMarsAuthorityDetail = Maps.newLinkedHashMap();
            for (Map.Entry entry : selectAuthorityModeValueMapping.entrySet()) {
                String marsAuthorityCode = (String)entry.getKey();
                Set selectAuthorityModeValues = (Set)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)selectAuthorityModeValues)) continue;
                LinkedHashMap mappedSelectModeGroupDetails = Maps.newLinkedHashMap();
                for (SelectAuthorityModeRegisterVo selectAuthorityModeRegisterVo : selectAuthorityModeValues) {
                    MarsAuthorityAstConverter marsAuthorityValueAstConverter;
                    String converterKey = selectAuthorityModeRegisterVo.getConverterKey();
                    boolean isArrayValue = selectAuthorityModeRegisterVo.getArrayValue();
                    Object value = selectAuthorityModeRegisterVo.getModeValue();
                    String selectModeGroupCode = selectAuthorityModeRegisterVo.getGroupCode();
                    String modeValueClass = selectAuthorityModeRegisterVo.getModeValueClass();
                    Class<?> sourceClass = null;
                    if (StringUtils.isNotBlank((CharSequence)modeValueClass)) {
                        try {
                            sourceClass = Class.forName(selectAuthorityModeRegisterVo.getModeValueClass());
                        }
                        catch (ClassNotFoundException e) {
                            LOGGER.warn("\u7ecf\u8fc7findByAuthorityCodes\u65b9\u6cd5\uff0c\u4e0d\u4f1a\u51fa\u73b0\u8fd9\u79cd\u60c5\u51b5");
                            continue;
                        }
                    }
                    if ((marsAuthorityValueAstConverter = this.findMarsAuthorityValueAstConverter(converterKey)) == null) continue;
                    Object valueAstResults = null;
                    if (!marsAuthorityValueAstConverter.support(sourceClass, isArrayValue) || (valueAstResults = marsAuthorityValueAstConverter.converter(databaseType, sourceClass, isArrayValue, value)) == null) continue;
                    Pair pair = Pair.of((Object)selectAuthorityModeRegisterVo, (Object)valueAstResults);
                    mappedSelectModeGroupDetails.put(selectModeGroupCode, pair);
                }
                if (CollectionUtils.isEmpty((Map)mappedSelectModeGroupDetails)) continue;
                mappedMarsAuthorityDetail.put(marsAuthorityCode, mappedSelectModeGroupDetails);
            }
            if (CollectionUtils.isEmpty((Map)mappedMarsAuthorityDetail)) {
                object = sourceSql;
                return object;
            }
            this.analysisMarsAuthorityDetail(selectedMarsAuthoritySqlConverter, mappedMarsAuthorityDetail, databaseType, sqlSelectQuery, currentConnection, marsAuthorityExpression);
            object = sqlSelectStatement.toString();
            return object;
        }
        finally {
            if (isOwner) {
                marsAuthorityContext.setBuilding(Boolean.valueOf(false));
            }
        }
    }

    private boolean analysisMarsAuthorityDetail(MarsAuthoritySqlConverter marsAuthoritySqlConverter, Map<String, Map<String, Pair<SelectAuthorityModeRegisterVo, Object>>> mappedMarsAuthorityDetail, DatabaseType databaseType, SQLSelectQueryBlock sqlSelectQuery, Connection currentConnection, String marsAuthorityExpression) {
        HashMap marsAuthorityConditionMapping = Maps.newHashMap();
        for (Map.Entry<String, Map<String, Pair<SelectAuthorityModeRegisterVo, Object>>> entry : mappedMarsAuthorityDetail.entrySet()) {
            Map<String, Pair<SelectAuthorityModeRegisterVo, Object>> mappedSelectModeGroup = entry.getValue();
            String marsAuthorityCode = entry.getKey();
            Pair<Boolean, SQLExpr> result = this.analysisSameLevelSql(marsAuthoritySqlConverter, mappedMarsAuthorityDetail, databaseType, sqlSelectQuery, currentConnection, marsAuthorityExpression, mappedSelectModeGroup);
            if (((Boolean)result.getLeft()).booleanValue()) {
                return true;
            }
            SQLExpr condition = (SQLExpr)result.getRight();
            if (condition == null) {
                return false;
            }
            marsAuthorityConditionMapping.put(marsAuthorityCode, condition);
        }
        if (CollectionUtils.isEmpty((Map)marsAuthorityConditionMapping) || marsAuthorityConditionMapping.size() != mappedMarsAuthorityDetail.size()) {
            return false;
        }
        for (Map.Entry<String, Map<String, Object>> entry : marsAuthorityConditionMapping.entrySet()) {
            String marsAuthorityCode = entry.getKey();
            SQLExpr authorityConditionExpr = (SQLExpr)entry.getValue();
            marsAuthorityExpression = StringUtils.replace((String)marsAuthorityExpression, (String)("[Authority_" + marsAuthorityCode + "]"), (String)SQLUtils.toSQLString((SQLObject)authorityConditionExpr, (String)databaseType.name()), (int)-1);
        }
        SQLExpr sqlNewWhere = SQLUtils.toSQLExpr((String)marsAuthorityExpression, (String)databaseType.name());
        SQLExpr sQLExpr = sqlSelectQuery.getWhere();
        if (sQLExpr == null) {
            sqlSelectQuery.setWhere(sqlNewWhere);
        } else {
            sqlSelectQuery.setWhere(SQLBinaryOpExpr.and((SQLExpr)sQLExpr, (SQLExpr)sqlNewWhere));
        }
        return true;
    }

    private Pair<Boolean, SQLExpr> analysisSameLevelSql(MarsAuthoritySqlConverter marsAuthoritySqlConverter, Map<String, Map<String, Pair<SelectAuthorityModeRegisterVo, Object>>> mappedMarsAuthorityDetail, DatabaseType databaseType, SQLSelectQueryBlock sqlSelectQuery, Connection connection, String marsAuthorityExpression, Map<String, Pair<SelectAuthorityModeRegisterVo, Object>> mappedSelectModeGroup) {
        LinkedHashSet tableNodes = Sets.newLinkedHashSet();
        boolean success = this.analysisTableNodes(marsAuthoritySqlConverter, mappedMarsAuthorityDetail, databaseType, sqlSelectQuery, connection, marsAuthorityExpression, tableNodes, sqlSelectQuery.getFrom());
        if (success) {
            return Pair.of((Object)false, null);
        }
        if (CollectionUtils.isEmpty((Collection)tableNodes)) {
            return Pair.of((Object)false, null);
        }
        MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        Set matchedMarsAuthoritys = marsAuthorityContext.getMatchedMarsAuthoritys();
        HashSet selectModeGroupCodes = Sets.newHashSet();
        for (MarsAuthority matchedMarsAuthority : matchedMarsAuthoritys) {
            Set marsAuthorityDetails = matchedMarsAuthority.getMarsSelectDetails();
            for (Object marsAuthorityDetail : marsAuthorityDetails) {
                selectModeGroupCodes.add(marsAuthorityDetail.getSelectModeGroupCode());
            }
        }
        List selectAuthorityModeGroupRegisters = this.selectAuthorityModeGroupRegisterService.findByGroupCodes(selectModeGroupCodes.toArray(new String[0]));
        if (CollectionUtils.isEmpty((Collection)selectAuthorityModeGroupRegisters)) {
            return Pair.of((Object)false, null);
        }
        Map<String, Set> requestMatchedFields = selectAuthorityModeGroupRegisters.stream().collect(Collectors.toMap(SelectAuthorityModeGroupRegisterVo::getGroupCode, SelectAuthorityModeGroupRegisterVo::getRepositoryFieldNames));
        if (CollectionUtils.isEmpty(requestMatchedFields)) {
            return Pair.of((Object)false, null);
        }
        HashSet alreadyMatchedAuthorityGroup = Sets.newHashSet();
        LinkedHashMap matchedTablesDimensionMapping = Maps.newLinkedHashMap();
        for (Object databaseTableNode : tableNodes) {
            Map map = marsAuthoritySqlConverter.analysisTableFileds(connection, (DatabaseTableNode)databaseTableNode, requestMatchedFields);
            if (CollectionUtils.isEmpty((Map)map)) continue;
            alreadyMatchedAuthorityGroup.addAll(map.keySet());
            for (String selectModGroupKey : map.keySet()) {
                requestMatchedFields.remove(selectModGroupKey);
            }
            matchedTablesDimensionMapping.put(databaseTableNode, map);
        }
        if (CollectionUtils.isEmpty((Map)matchedTablesDimensionMapping)) {
            return Pair.of((Object)false, null);
        }
        if (alreadyMatchedAuthorityGroup.size() != selectModeGroupCodes.size()) {
            return Pair.of((Object)false, null);
        }
        LinkedHashMap marsAuthorityExprConditionMappings = Maps.newLinkedHashMap();
        for (Map.Entry entry : matchedTablesDimensionMapping.entrySet()) {
            DatabaseTableNode databaseTableNode = (DatabaseTableNode)entry.getKey();
            String alias = databaseTableNode.getAlias();
            String tableName = databaseTableNode.getTableName();
            Map matchedDimensionMapping = (Map)entry.getValue();
            for (Map.Entry matchedDimensionMappingItem : matchedDimensionMapping.entrySet()) {
                String selectModeGroupCode = (String)matchedDimensionMappingItem.getKey();
                String fieldName = (String)matchedDimensionMappingItem.getValue();
                Pair<SelectAuthorityModeRegisterVo, Object> marsAuthorityDetailPair = mappedSelectModeGroup.get(selectModeGroupCode);
                if (ObjectUtils.isEmpty(marsAuthorityDetailPair)) continue;
                SelectAuthorityModeRegisterVo selectAuthorityModeRegisterVo = (SelectAuthorityModeRegisterVo)marsAuthorityDetailPair.getLeft();
                String modeKey = selectAuthorityModeRegisterVo.getModeKey();
                String converterKey = selectAuthorityModeRegisterVo.getConverterKey();
                MarsAuthorityAstConverter marsAuthorityValueAstConverter = this.findMarsAuthorityValueAstConverter(converterKey);
                Object astValue = marsAuthorityDetailPair.getRight();
                if (astValue == null) continue;
                SQLExpr sqlExpr = marsAuthorityValueAstConverter.op(tableName, alias, fieldName, astValue);
                marsAuthorityExprConditionMappings.put(modeKey, sqlExpr);
            }
        }
        SQLExpr result = null;
        for (Map.Entry entryItem : marsAuthorityExprConditionMappings.entrySet()) {
            if (result == null) {
                result = (SQLExpr)entryItem.getValue();
                continue;
            }
            result = SQLBinaryOpExpr.and((SQLExpr)result, (SQLExpr)((SQLExpr)entryItem.getValue()));
        }
        return Pair.of((Object)false, result);
    }

    private boolean analysisTableNodes(MarsAuthoritySqlConverter marsAuthoritySqlConverter, Map<String, Map<String, Pair<SelectAuthorityModeRegisterVo, Object>>> mappedMarsAuthorityDetail, DatabaseType databaseType, SQLSelectQueryBlock sqlSelectQuery, Connection connection, String marsAuthorityExpression, Set<DatabaseTableNode> tableNodes, SQLTableSource fromSQLTableSource) {
        if (fromSQLTableSource instanceof SQLExprTableSource) {
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)fromSQLTableSource;
            DatabaseTableNode databaseTableNode = this.buildTableNode(sqlExprTableSource);
            if (databaseTableNode != null) {
                tableNodes.add(databaseTableNode);
            }
        } else {
            if (fromSQLTableSource instanceof SQLJoinTableSource) {
                SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)fromSQLTableSource;
                SQLTableSource leftSQLTableSource = sqlJoinTableSource.getLeft();
                boolean leftSuccess = this.analysisTableNodes(marsAuthoritySqlConverter, mappedMarsAuthorityDetail, databaseType, sqlSelectQuery, connection, marsAuthorityExpression, tableNodes, leftSQLTableSource);
                SQLTableSource rightSQLTableSource = sqlJoinTableSource.getRight();
                boolean rightSuccess = this.analysisTableNodes(marsAuthoritySqlConverter, mappedMarsAuthorityDetail, databaseType, sqlSelectQuery, connection, marsAuthorityExpression, tableNodes, rightSQLTableSource);
                return leftSuccess || rightSuccess;
            }
            if (fromSQLTableSource instanceof SQLSubqueryTableSource) {
                SQLSubqueryTableSource subQueryTableSource = (SQLSubqueryTableSource)fromSQLTableSource;
                Boolean pageCountSql = this.isPageCountNestSql(sqlSelectQuery);
                DatabaseTableNode databaseTableNode = this.buildTableNode(subQueryTableSource);
                if (databaseTableNode != null && Boolean.FALSE.equals(pageCountSql)) {
                    tableNodes.add(databaseTableNode);
                } else {
                    SQLSelect sqlSelect = subQueryTableSource.getSelect();
                    SQLSelectQueryBlock subSqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
                    return this.analysisMarsAuthorityDetail(marsAuthoritySqlConverter, mappedMarsAuthorityDetail, databaseType, subSqlSelectQuery, connection, marsAuthorityExpression);
                }
            }
        }
        return false;
    }

    private boolean analysisSimpleTableNodes(SQLSelectQueryBlock sqlSelectQuery, Set<DatabaseTableNode> tableNodes, SQLTableSource fromSQLTableSource) {
        if (fromSQLTableSource instanceof SQLExprTableSource) {
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)fromSQLTableSource;
            DatabaseTableNode databaseTableNode = this.buildTableNode(sqlExprTableSource);
            if (databaseTableNode != null) {
                tableNodes.add(databaseTableNode);
            }
        } else {
            if (fromSQLTableSource instanceof SQLJoinTableSource) {
                SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)fromSQLTableSource;
                SQLTableSource leftSQLTableSource = sqlJoinTableSource.getLeft();
                boolean leftSuccess = this.analysisSimpleTableNodes(sqlSelectQuery, tableNodes, leftSQLTableSource);
                SQLTableSource rightSQLTableSource = sqlJoinTableSource.getRight();
                boolean rightSuccess = this.analysisSimpleTableNodes(sqlSelectQuery, tableNodes, rightSQLTableSource);
                return leftSuccess || rightSuccess;
            }
            if (fromSQLTableSource instanceof SQLSubqueryTableSource) {
                SQLSubqueryTableSource subQueryTableSource = (SQLSubqueryTableSource)fromSQLTableSource;
                Boolean pageCountSql = this.isPageCountNestSql(sqlSelectQuery);
                DatabaseTableNode databaseTableNode = this.buildTableNode(subQueryTableSource);
                if (databaseTableNode != null && Boolean.FALSE.equals(pageCountSql)) {
                    tableNodes.add(databaseTableNode);
                } else {
                    SQLSelect sqlSelect = subQueryTableSource.getSelect();
                    SQLSelectQueryBlock subSqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
                    return this.analysisSimpleTableNodes(subSqlSelectQuery, tableNodes, subSqlSelectQuery.getFrom());
                }
            }
        }
        return false;
    }

    private MarsAuthorityAstConverter findMarsAuthorityValueAstConverter(String converterKey) {
        if (CollectionUtils.isEmpty(this.marsAuthorityValueAstConverters)) {
            return null;
        }
        for (MarsAuthorityAstConverter marsAuthorityValueAstConverter : this.marsAuthorityValueAstConverters) {
            String currentConverterKey = marsAuthorityValueAstConverter.converterKey();
            if (!StringUtils.equals((CharSequence)currentConverterKey, (CharSequence)converterKey)) continue;
            return marsAuthorityValueAstConverter;
        }
        return null;
    }

    private DatabaseTableNode buildTableNode(SQLExprTableSource sqlTableSource) {
        String alias = sqlTableSource.getAlias();
        SQLExpr sqlExpr = sqlTableSource.getExpr();
        if (sqlExpr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr sqlIdentifierExpr = (SQLIdentifierExpr)sqlExpr;
            String tableName = sqlIdentifierExpr.getName();
            DatabaseTableNode databaseTableNode = new DatabaseTableNode();
            databaseTableNode.setAlias(alias);
            databaseTableNode.setTableName(tableName);
            databaseTableNode.setSubQueryFlag(Boolean.FALSE);
            return databaseTableNode;
        }
        return null;
    }

    private DatabaseTableNode buildTableNode(SQLSubqueryTableSource subQueryTableSource) {
        String alias = subQueryTableSource.getAlias();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            DatabaseTableNode databaseTableNode = new DatabaseTableNode();
            databaseTableNode.setSubQueryFlag(Boolean.TRUE);
            databaseTableNode.setAlias(alias);
            databaseTableNode.setTableName(alias);
            databaseTableNode.setSubQuerySql(subQueryTableSource.toString());
            return databaseTableNode;
        }
        return null;
    }

    private Boolean isPageCountNestSql(SQLSelectQueryBlock sqlSelectQuery) {
        SQLSelectGroupByClause groupBy = sqlSelectQuery.getGroupBy();
        if (Objects.nonNull(groupBy)) {
            return Boolean.FALSE;
        }
        List selectList = sqlSelectQuery.getSelectList();
        if (CollectionUtils.isEmpty((Collection)selectList) || selectList.size() > 1) {
            return Boolean.FALSE;
        }
        SQLExpr expr = ((SQLSelectItem)selectList.get(0)).getExpr();
        if (expr instanceof SQLAggregateExpr) {
            SQLAggregateExpr sqlAggregateExpr = (SQLAggregateExpr)expr;
            String methodName = sqlAggregateExpr.getMethodName();
            String alias = sqlSelectQuery.getFrom().getAlias();
            if ("count".equalsIgnoreCase(methodName) && ("total".equalsIgnoreCase(alias) || "countresultTable".equalsIgnoreCase(alias))) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static void main(String[] args) throws SQLSyntaxErrorException {
        SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)MarsMybatisSqlUtils.parser((String)"select count(*) from aaaa", (String)"mysql");
        SQLSelect sqlSelect = sqlSelectStatement.getSelect();
        SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
        List selectList = sqlSelectQuery.getSelectList();
        System.out.println(1111);
    }

    public int sort() {
        return 0;
    }
}

