/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.strategy;

import com.bizunited.nebula.common.interceptor.ElasticsearchQueryInterceptorStrategy;
import com.bizunited.nebula.common.service.es.ElasticsearchQueryService;
import com.bizunited.nebula.mars.local.service.helper.MarsAuthorityServiceHelper;
import com.bizunited.nebula.mars.local.vo.MarsExpressionOperatorVo;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.bizunited.nebula.mars.sdk.converter.MarsElasticsearchAuthorityAstConverter;
import com.bizunited.nebula.mars.sdk.enums.MarsAuthorityOperatorTypeEnum;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityExpressionService;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityService;
import com.bizunited.nebula.mars.sdk.service.SelectAuthorityModeGroupRegisterService;
import com.bizunited.nebula.mars.sdk.service.SelectAuthorityModeRegisterService;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthority;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthorityExpressionVo;
import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeGroupRegisterVo;
import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeRegisterVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarsElasticsearchQueryInterceptorStrategy
implements ElasticsearchQueryInterceptorStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarsElasticsearchQueryInterceptorStrategy.class);
    @Autowired
    private MarsAuthorityService marsAuthorityService;
    @Autowired
    private SelectAuthorityModeRegisterService selectAuthorityModeRegisterService;
    @Autowired
    private MarsAuthorityServiceHelper marsAuthorityServiceHelper;
    @Autowired
    private ElasticsearchQueryService elasticsearchQueryService;
    @Autowired(required=false)
    private List<MarsElasticsearchAuthorityAstConverter> marsElasticsearchAuthorityAstConverters;
    @Autowired
    private SelectAuthorityModeGroupRegisterService groupRegisterService;
    @Autowired
    private MarsAuthorityExpressionService marsAuthorityExpressionService;

    public int sort() {
        return 0;
    }

    public void intercept(SearchRequest searchRequest) {
        Map selectAuthorityModeValueMapping;
        HashSet sqlTableNames;
        String selectTableNames;
        HashSet pointTableNames;
        MarsAuthorityExpressionVo marsAuthorityExpressionVo;
        if (Objects.isNull(searchRequest) || Objects.isNull(searchRequest.source())) {
            return;
        }
        Object[] indices = searchRequest.indices();
        if (Objects.isNull(indices) || indices.length != 1) {
            return;
        }
        MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        String listCode = marsAuthorityContext.getListCode();
        if (StringUtils.isBlank((CharSequence)listCode)) {
            return;
        }
        if (marsAuthorityContext.building().booleanValue()) {
            return;
        }
        if (!marsAuthorityContext.building().booleanValue()) {
            marsAuthorityContext.setBuilding(Boolean.valueOf(true));
        }
        if (Objects.nonNull(marsAuthorityExpressionVo = this.marsAuthorityExpressionService.findByListCode(marsAuthorityContext.getListCode())) && StringUtils.isNotBlank((CharSequence)marsAuthorityExpressionVo.getSelectTableNames()) && !(pointTableNames = Sets.newHashSet((Object[])(selectTableNames = marsAuthorityExpressionVo.getSelectTableNames()).split(","))).equals(sqlTableNames = Sets.newHashSet((Object[])indices))) {
            return;
        }
        Set marsAuthorityCodes = marsAuthorityContext.getMatchedMarsAuthorityCodes();
        if (CollectionUtils.isEmpty((Collection)marsAuthorityCodes)) {
            Set matchedMarsAuthoritys = this.marsAuthorityService.findByListCodeAndCurrentUser(listCode);
            if (CollectionUtils.isEmpty((Collection)matchedMarsAuthoritys)) {
                return;
            }
            marsAuthorityCodes = matchedMarsAuthoritys.stream().filter(item -> item.getStatus() == 1).map(MarsAuthority::getCode).collect(Collectors.toSet());
            marsAuthorityContext.setMatchedMarsAuthorityCodes(marsAuthorityCodes);
            marsAuthorityContext.setMatchedMarsAuthoritys(matchedMarsAuthoritys);
        }
        if (CollectionUtils.isEmpty((Map)(selectAuthorityModeValueMapping = this.selectAuthorityModeRegisterService.findByAuthorityCodes(marsAuthorityCodes)))) {
            return;
        }
        MarsExpressionOperatorVo marsExpressionOperatorVo = this.marsAuthorityServiceHelper.buildExpressionOperator(marsAuthorityContext, selectAuthorityModeValueMapping, marsAuthorityExpressionVo);
        this.convertRegisterModelValue(marsExpressionOperatorVo);
        if (CollectionUtils.isEmpty(marsExpressionOperatorVo.getModeRegisterList()) && CollectionUtils.isEmpty(marsExpressionOperatorVo.getChildrenList())) {
            LOGGER.warn("ES\u6784\u5efa\u6570\u636e\u6743\u9650\u8868\u8fbe\u5f0f\u8fd0\u7b97\u4fe1\u606f\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!");
            return;
        }
        if (Objects.isNull(marsExpressionOperatorVo.getOperatorType())) {
            LOGGER.warn("ES\u6784\u5efa\u6570\u636e\u6743\u9650\u8868\u8fbe\u5f0f\u8fd0\u7b97\u7b26\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!");
            return;
        }
        this.analysisMarsAuthorityDetail(searchRequest, marsExpressionOperatorVo);
    }

    private MarsElasticsearchAuthorityAstConverter findMarsElasticsearchAuthorityAstConverter(String converterKey) {
        if (CollectionUtils.isEmpty(this.marsElasticsearchAuthorityAstConverters)) {
            return null;
        }
        for (MarsElasticsearchAuthorityAstConverter marsAuthorityValueAstConverter : this.marsElasticsearchAuthorityAstConverters) {
            String currentConverterKey = marsAuthorityValueAstConverter.converterKey();
            if (!StringUtils.equals((CharSequence)currentConverterKey, (CharSequence)converterKey)) continue;
            return marsAuthorityValueAstConverter;
        }
        return null;
    }

    private void convertRegisterModelValue(MarsExpressionOperatorVo marsExpressionOperatorVo) {
        if (!CollectionUtils.isEmpty(marsExpressionOperatorVo.getModeRegisterList())) {
            ArrayList list = Lists.newArrayList();
            for (SelectAuthorityModeRegisterVo selectAuthorityModeRegisterVo : marsExpressionOperatorVo.getModeRegisterList()) {
                MarsElasticsearchAuthorityAstConverter marsElasticsearchAuthorityAstConverter;
                String converterKey = selectAuthorityModeRegisterVo.getConverterKey();
                boolean isArrayValue = selectAuthorityModeRegisterVo.getArrayValue();
                Object value = selectAuthorityModeRegisterVo.getModeValue();
                String modeValueClass = selectAuthorityModeRegisterVo.getModeValueClass();
                Class<?> sourceClass = null;
                if (StringUtils.isNotBlank((CharSequence)modeValueClass)) {
                    try {
                        sourceClass = Class.forName(selectAuthorityModeRegisterVo.getModeValueClass());
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.warn("\u7ecf\u8fc7findByAuthorityCodes\u65b9\u6cd5\uff0c\u4e0d\u4f1a\u51fa\u73b0\u8fd9\u79cd\u60c5\u51b5");
                        continue;
                    }
                }
                if ((marsElasticsearchAuthorityAstConverter = this.findMarsElasticsearchAuthorityAstConverter(converterKey)) == null) {
                    LOGGER.warn("\u672a\u627e\u5230\u6570\u636e\u6743\u9650\u503c\u8f6c\u6362\u5668\u5b9e\u73b0converterKey:{}", (Object)converterKey);
                    continue;
                }
                if (!marsElasticsearchAuthorityAstConverter.support(sourceClass, isArrayValue)) {
                    LOGGER.warn("\u6570\u636e\u6743\u9650\u503c\u8f6c\u6362\u5668\u5b9e\u73b0\u4e0d\u652f\u6301\u5bf9\u5e94\u6570\u636e\u7c7b\u578bconverterKey:{}", (Object)converterKey);
                    continue;
                }
                Object valueAstResults = marsElasticsearchAuthorityAstConverter.converter(sourceClass, isArrayValue, value);
                if (Objects.isNull(valueAstResults)) {
                    LOGGER.warn("\u6570\u636e\u6743\u9650\u503c\u8f6c\u6362\u5668\u8f6c\u6362\u7ed3\u679c\u503c\u4e3a\u7a7aconverterKey:{}", (Object)converterKey);
                    continue;
                }
                selectAuthorityModeRegisterVo.setConverterModeValue(valueAstResults);
                list.add(selectAuthorityModeRegisterVo);
            }
            marsExpressionOperatorVo.setModeRegisterList(list);
        }
        if (!CollectionUtils.isEmpty(marsExpressionOperatorVo.getChildrenList())) {
            marsExpressionOperatorVo.getChildrenList().forEach(this::convertRegisterModelValue);
        }
    }

    private void analysisMarsAuthorityDetail(SearchRequest searchRequest, MarsExpressionOperatorVo marsExpressionOperatorVo) {
        String indexName = searchRequest.indices()[0];
        Set<String> indexFieldNames = this.analysisIndexFieldNames(indexName);
        if (CollectionUtils.isEmpty(indexFieldNames)) {
            LOGGER.warn("ES\u6570\u636e\u6743\u9650\u5339\u914d,\u6ca1\u6709\u83b7\u53d6\u5230\u7d22\u5f15[{}]\u7684\u5b57\u6bb5\u4fe1\u606f,\u8bf7\u68c0\u67e5!", (Object)indexName);
            return;
        }
        BoolQueryBuilder addQueryBuilder = this.buildBoolQueryBuilder(searchRequest, marsExpressionOperatorVo, indexFieldNames);
        if (Objects.nonNull(addQueryBuilder)) {
            SearchSourceBuilder searchSourceBuilder = searchRequest.source();
            BoolQueryBuilder resultQueryBuilder = QueryBuilders.boolQuery();
            QueryBuilder originalQueryBuilder = searchSourceBuilder.query();
            resultQueryBuilder.filter((QueryBuilder)addQueryBuilder);
            resultQueryBuilder.must(originalQueryBuilder);
            searchSourceBuilder.query((QueryBuilder)resultQueryBuilder);
        }
    }

    private Set<String> analysisIndexFieldNames(String indexName) {
        try {
            GetMappingsRequest mappingsRequest = new GetMappingsRequest().indices(new String[]{indexName});
            GetMappingsResponse fieldMapping = this.elasticsearchQueryService.queryWithMapping(mappingsRequest);
            if (Objects.isNull(fieldMapping) || Objects.isNull(fieldMapping.mappings()) || fieldMapping.mappings().isEmpty()) {
                return null;
            }
            MappingMetadata mappingMetadata = (MappingMetadata)fieldMapping.mappings().get(indexName);
            if (Objects.isNull(mappingMetadata)) {
                return null;
            }
            Map sourceAsMap = mappingMetadata.getSourceAsMap();
            if (Objects.isNull(sourceAsMap) || sourceAsMap.isEmpty()) {
                return null;
            }
            Map propertiesMap = (Map)sourceAsMap.get("properties");
            if (Objects.isNull(propertiesMap) || propertiesMap.isEmpty()) {
                return null;
            }
            return propertiesMap.keySet();
        }
        catch (Exception e) {
            LOGGER.error("\u6570\u636e\u6743\u9650\u83b7\u53d6\u7d22\u5f15[{}]\u5b57\u6bb5\u4fe1\u606f\u5f02\u5e38,\u8bf7\u68c0\u67e5!", (Object)indexName);
            return null;
        }
    }

    private BoolQueryBuilder buildBoolQueryBuilder(SearchRequest searchRequest, MarsExpressionOperatorVo marsExpressionOperatorVo, Set<String> indexFieldNames) {
        List<MarsExpressionOperatorVo> childrenList;
        Integer operatorType = marsExpressionOperatorVo.getOperatorType();
        if (!Objects.equals(operatorType, MarsAuthorityOperatorTypeEnum.AND.getType()) && !Objects.equals(operatorType, MarsAuthorityOperatorTypeEnum.OR.getType())) {
            LOGGER.warn("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6743\u9650\u8868\u8fbe\u516c\u5f0f\u7c7b\u578b:{}, \u8bf7\u68c0\u67e5!", (Object)operatorType);
            return null;
        }
        ArrayList conditionQueryBuilders = Lists.newArrayList();
        List<SelectAuthorityModeRegisterVo> modeRegisterList = marsExpressionOperatorVo.getModeRegisterList();
        if (!CollectionUtils.isEmpty(modeRegisterList)) {
            for (SelectAuthorityModeRegisterVo modeRegisterVo : modeRegisterList) {
                MarsElasticsearchAuthorityAstConverter converter = this.findMarsElasticsearchAuthorityAstConverter(modeRegisterVo.getConverterKey());
                if (Objects.isNull(converter)) {
                    LOGGER.warn("\u672a\u627e\u5230ES\u6570\u636e\u6743\u9650\u503c\u8f6c\u6362\u5668[{}],\u8bf7\u68c0\u67e5!", (Object)modeRegisterVo.getConverterKey());
                    continue;
                }
                String matchFieldName = this.matchFieldName(modeRegisterVo, indexFieldNames);
                if (!StringUtils.isNotBlank((CharSequence)matchFieldName)) continue;
                QueryBuilder queryBuilder = converter.op(matchFieldName, modeRegisterVo.getConverterModeValue());
                conditionQueryBuilders.add(queryBuilder);
            }
        }
        if (!CollectionUtils.isEmpty(childrenList = marsExpressionOperatorVo.getChildrenList())) {
            for (MarsExpressionOperatorVo operatorVo : childrenList) {
                BoolQueryBuilder queryBuilder = this.buildBoolQueryBuilder(searchRequest, operatorVo, indexFieldNames);
                if (!Objects.nonNull(queryBuilder)) continue;
                conditionQueryBuilders.add(queryBuilder);
            }
        }
        if (CollectionUtils.isEmpty((Collection)conditionQueryBuilders)) {
            return null;
        }
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        for (QueryBuilder conditionQueryBuilder : conditionQueryBuilders) {
            if (Objects.equals(operatorType, MarsAuthorityOperatorTypeEnum.AND.getType())) {
                builder.must(conditionQueryBuilder);
                continue;
            }
            if (!Objects.equals(operatorType, MarsAuthorityOperatorTypeEnum.OR.getType())) continue;
            builder.should(conditionQueryBuilder);
        }
        return builder;
    }

    private String matchFieldName(SelectAuthorityModeRegisterVo modeRegisterVo, Set<String> indexFieldNames) {
        SelectAuthorityModeGroupRegisterVo groupRegisterVo = this.groupRegisterService.findByGroupCode(modeRegisterVo.getGroupCode());
        if (Objects.isNull(groupRegisterVo)) {
            LOGGER.warn("\u672a\u627e\u5230\u6570\u636e\u6743\u9650\u5206\u7ec4\u4fe1\u606f[{}],\u8bf7\u68c0\u67e5!", (Object)modeRegisterVo.getGroupCode());
            return null;
        }
        Set possibleFieldNames = groupRegisterVo.getRepositoryFieldNames();
        possibleFieldNames = (Set)ObjectUtils.defaultIfNull((Object)possibleFieldNames, (Object)Sets.newHashSet());
        for (String indexFiledName : indexFieldNames) {
            for (String possibleFieldName : possibleFieldNames) {
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)indexFiledName, (CharSequence[])new CharSequence[]{possibleFieldName})) continue;
                return indexFiledName;
            }
        }
        return null;
    }
}

