/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.sdk.converter;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.mars.sdk.converter.MarsAuthoritySqlConverter;
import com.bizunited.nebula.mars.sdk.vo.DatabaseTableNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mysql.cj.jdbc.result.ResultSetMetaData;
import com.mysql.cj.result.Field;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractMarsAuthoritySqlConverter
implements MarsAuthoritySqlConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMarsAuthoritySqlConverter.class);
    private static LoadingCache<String, Set<RepositoryTableNode>> appCodeTableNodes = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Set<RepositoryTableNode>>(){

        public Set<RepositoryTableNode> load(String key) throws Exception {
            return Sets.newConcurrentHashSet();
        }
    });

    @Override
    public Map<String, String> analysisTableFileds(Connection connection, DatabaseTableNode databaseTableNode, Map<String, Set<String>> requestMatchedFields) {
        RepositoryTableNode repositoryTableNode;
        Set<String> fieldNames;
        String appCode = TenantUtils.getTenantCode();
        if (connection == null || databaseTableNode == null || StringUtils.isBlank((CharSequence)databaseTableNode.getTableName()) || CollectionUtils.isEmpty(requestMatchedFields)) {
            return null;
        }
        String tableName = databaseTableNode.getTableName();
        if (databaseTableNode.getSubQueryFlag().booleanValue()) {
            List<Field> fieldList = this.findFieldBySql(connection, databaseTableNode.getSubQuerySql());
            if (CollectionUtils.isEmpty(fieldList)) {
                return null;
            }
            fieldNames = fieldList.stream().map(Field::getColumnLabel).collect(Collectors.toSet());
            repositoryTableNode = new RepositoryTableNode(tableName, fieldNames);
        } else {
            repositoryTableNode = this.findCacheTableNode(appCode, tableName);
            if (repositoryTableNode == null) {
                repositoryTableNode = this.findRepositoryTableNode(connection, tableName);
                if (repositoryTableNode != null) {
                    this.addCacheTableNode(appCode, repositoryTableNode);
                } else {
                    return null;
                }
            }
        }
        LinkedHashMap matchedDimensionMapping = Maps.newLinkedHashMap();
        fieldNames = repositoryTableNode.getFields();
        block0: for (String filedName : fieldNames) {
            for (Map.Entry<String, Set<String>> requestMatchedFieldEntry : requestMatchedFields.entrySet()) {
                String dimensionKey = requestMatchedFieldEntry.getKey();
                Set<String> possibleFieldNames = requestMatchedFieldEntry.getValue();
                for (String possibleFieldName : possibleFieldNames) {
                    if (!StringUtils.equalsAnyIgnoreCase((CharSequence)filedName, (CharSequence[])new CharSequence[]{possibleFieldName})) continue;
                    matchedDimensionMapping.put(dimensionKey, possibleFieldName);
                    continue block0;
                }
            }
        }
        if (CollectionUtils.isEmpty((Map)matchedDimensionMapping)) {
            return null;
        }
        return matchedDimensionMapping;
    }

    private List<Field> findFieldBySql(Connection connection, String sql) {
        ArrayList fieldList = Lists.newArrayList();
        try {
            CallableStatement callableStatement = connection.prepareCall(sql);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)callableStatement.getMetaData();
            Object[] fields = resultSetMetaData.getFields();
            fieldList = Lists.newArrayList((Object[])fields);
        }
        catch (SQLException e) {
            LOGGER.warn("\u65e0\u6cd5\u89e3\u6790sql\uff08{}\uff09\u7684\u7ed3\u6784\u4fe1\u606f\uff0c\u6700\u53ef\u80fd\u7684\u60c5\u51b5\u662f\u8fd9\u662f\u4e00\u4e2a\u89c6sql\u5b58\u5728\u95ee\u9898\uff0c\u6216\u6570\u636e\u5e93\u8fde\u63a5\u8d26\u6237\u6ca1\u6709\u5bf9\u5e94\u7684\u67e5\u8be2\u6743\u9650", (Object)sql);
        }
        return fieldList;
    }

    private RepositoryTableNode findCacheTableNode(String appCode, String tableName) {
        Set repositoryTableNodes = null;
        try {
            repositoryTableNodes = (Set)appCodeTableNodes.get((Object)appCode);
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        RepositoryTableNode currentTableNode = null;
        for (RepositoryTableNode repositoryTableNode : repositoryTableNodes) {
            if (!StringUtils.equals((CharSequence)repositoryTableNode.getTableName(), (CharSequence)tableName)) continue;
            currentTableNode = repositoryTableNode;
            break;
        }
        return currentTableNode;
    }

    private void addCacheTableNode(String appCode, RepositoryTableNode tableNode) {
        Set repositoryTableNodes = null;
        try {
            repositoryTableNodes = (Set)appCodeTableNodes.get((Object)appCode);
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        repositoryTableNodes.add(tableNode);
    }

    protected abstract RepositoryTableNode findRepositoryTableNode(Connection var1, String var2);

    protected static class RepositoryTableNode {
        private String tableName;
        private Set<String> fields = Sets.newHashSet();

        public RepositoryTableNode(String tableName, Set<String> fields) {
            this.tableName = tableName;
            this.fields = fields;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Set<String> getFields() {
            return this.fields;
        }
    }
}

