/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.sdk.converter;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.nebula.mars.sdk.converter.MarsElasticsearchAuthorityAstConverter;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.stereotype.Component;

@Component
public class ChartArrayMarsElasticsearchAuthorityAstConverter
implements MarsElasticsearchAuthorityAstConverter {
    public static final String CONVERTER_KEY = "chartArrayMarsAuthorityAstConverter";

    @Override
    public String converterKey() {
        return CONVERTER_KEY;
    }

    @Override
    public boolean support(Class<?> sourceClass, boolean isArrayValue) {
        if (!isArrayValue) {
            return false;
        }
        return CharSequence.class.isAssignableFrom(sourceClass);
    }

    @Override
    public Object converter(Class<?> sourceClass, boolean isArrayValue, Object sourceValue) {
        Object[] sourceValues = null;
        if (sourceValue instanceof JSONArray) {
            sourceValues = (String[])((JSONArray)sourceValue).toArray((Object[])new String[0]);
        } else {
            Object[] sourceValueObjects = (Object[])sourceValue;
            sourceValues = (String[])Arrays.stream(sourceValueObjects).map(Object::toString).toArray(String[]::new);
        }
        return Lists.newArrayList((Object[])sourceValues);
    }

    @Override
    public QueryBuilder op(String fieldName, Object fieldValue) {
        return QueryBuilders.termsQuery((String)fieldName, (Collection)((List)fieldValue));
    }
}

