/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.sdk.converter;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.nebula.mars.sdk.converter.MarsMongoAuthorityAstConverter;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Component;

@Component
public class ChartArrayMarsMongoAuthorityAstConverter
implements MarsMongoAuthorityAstConverter {
    public static final String CONVERTER_KEY = "chartArrayMarsAuthorityAstConverter";

    @Override
    public String converterKey() {
        return CONVERTER_KEY;
    }

    @Override
    public boolean support(Class<?> sourceClass, boolean isArrayValue) {
        if (!isArrayValue) {
            return false;
        }
        return CharSequence.class.isAssignableFrom(sourceClass);
    }

    @Override
    public Object converter(Class<?> sourceClass, boolean isArrayValue, Object sourceValue) {
        Object[] sourceValues = null;
        if (sourceValue instanceof JSONArray) {
            sourceValues = (String[])((JSONArray)sourceValue).toArray((Object[])new String[0]);
        } else {
            Object[] sourceValueObjects = (Object[])sourceValue;
            sourceValues = (String[])Arrays.stream(sourceValueObjects).map(Object::toString).toArray(String[]::new);
        }
        return Lists.newArrayList((Object[])sourceValues);
    }

    @Override
    public Criteria op(String fieldName, Object fieldValue) {
        return Criteria.where((String)fieldName).in((Collection)((List)fieldValue));
    }
}

