/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.sdk.converter;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.bizunited.nebula.common.enums.DatabaseType;
import com.bizunited.nebula.mars.sdk.converter.AbstractMarsAuthoritySqlConverter;
import com.bizunited.nebula.mars.sdk.utils.MarsMybatisSqlUtils;
import java.sql.Connection;
import java.sql.SQLSyntaxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OracleMarsAuthoritySqlConverter
extends AbstractMarsAuthoritySqlConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleMarsAuthoritySqlConverter.class);

    @Override
    public boolean support(DatabaseType databaseType) {
        return databaseType == DatabaseType.ORACLE;
    }

    @Override
    public SQLStatement converter(String sql, DatabaseType databaseType) {
        try {
            return MarsMybatisSqlUtils.parser(sql, "oracle");
        }
        catch (SQLSyntaxErrorException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected AbstractMarsAuthoritySqlConverter.RepositoryTableNode findRepositoryTableNode(Connection connection, String tableName) {
        LOGGER.warn("\u76ee\u524d\u7248\u672c\u6682\u4e0d\u652f\u6301oracle\u7684\u5b57\u6bb5\u5339\u914d\uff0c\u8be5\u6b21\u6570\u636e\u6743\u9650\u5339\u914d\u64cd\u4f5c\u88ab\u5ffd\u7565");
        return null;
    }
}

