/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.sdk.converter;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.bizunited.nebula.common.enums.DatabaseType;
import com.bizunited.nebula.mars.sdk.converter.AbstractMarsAuthoritySqlConverter;
import com.bizunited.nebula.mars.sdk.converter.MySQLMarsAuthoritySqlConverter;
import com.bizunited.nebula.mars.sdk.utils.MarsMybatisSqlUtils;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PostgreSQLMarsAuthoritySqlConverter
extends AbstractMarsAuthoritySqlConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLMarsAuthoritySqlConverter.class);

    @Override
    public boolean support(DatabaseType databaseType) {
        return databaseType == DatabaseType.POSTGRESQL;
    }

    @Override
    public SQLStatement converter(String sql, DatabaseType databaseType) {
        try {
            return MarsMybatisSqlUtils.parser(sql, "postgresql");
        }
        catch (SQLSyntaxErrorException var4) {
            LOGGER.error(var4.getMessage(), (Throwable)var4);
            return null;
        }
    }

    @Override
    protected AbstractMarsAuthoritySqlConverter.RepositoryTableNode findRepositoryTableNode(Connection connection, String tableName) {
        String tableFieldSql = "SELECT column_name\nFROM information_schema.columns \nWHERE table_name='" + tableName + "'";
        boolean isExist = false;
        LinkedHashSet fieldNames = Sets.newLinkedHashSet();
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(tableFieldSql);){
            while (resultSet.next()) {
                isExist = true;
                String filedName = resultSet.getString("column_name");
                fieldNames.add(filedName);
            }
        }
        catch (SQLException var38) {
            LOGGER.warn("\u6ca1\u6709\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u6307\u5b9a\u6570\u636e\u8868\uff08{}\uff09\u7684\u7ed3\u6784\u4fe1\u606f\uff0c\u6700\u53ef\u80fd\u7684\u60c5\u51b5\u662f\u8fd9\u662f\u4e00\u4e2a\u89c6\u56fe\u6216\u8005\u7ed3\u6784\u5b58\u5728\u95ee\u9898\uff0c\u6216\u8005\u6240\u4f7f\u7528\u7684\u6570\u636e\u5e93\u8fde\u63a5\u8d26\u6237\u6ca1\u6709\u5bf9\u5e94\u7684\u67e5\u8be2\u6743\u9650", (Object)tableName);
        }
        if (!isExist) {
            return null;
        }
        AbstractMarsAuthoritySqlConverter.RepositoryTableNode repositoryTableNode = new AbstractMarsAuthoritySqlConverter.RepositoryTableNode(tableName, fieldNames);
        return repositoryTableNode;
    }
}

