/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.service.internal;

import com.bizunited.nebula.monitor.local.dto.InterfaceInvokeLogCycleDto;
import com.bizunited.nebula.monitor.local.entity.InterfaceInvokeLogCycle;
import com.bizunited.nebula.monitor.local.repository.InterfaceInvokeLogCycleRepository;
import com.bizunited.nebula.monitor.local.service.InterfaceInvokeLogCycleService;
import com.bizunited.nebula.monitor.sdk.enums.LogSaveCycleUnitEnum;
import com.bizunited.nebula.monitor.sdk.vo.InterfaceLogSaveCycleVo;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InterfaceInvokeLogCycleServiceImpl
implements InterfaceInvokeLogCycleService {
    @Autowired
    private InterfaceInvokeLogCycleRepository interfaceInvokeLogCycleRepository;

    @Override
    @Transactional
    public void updateLogSaveCycle(InterfaceInvokeLogCycleDto interfaceInvokeLogCycleDto) {
        if (interfaceInvokeLogCycleDto == null) {
            interfaceInvokeLogCycleDto = new InterfaceInvokeLogCycleDto();
        }
        String localSystem = interfaceInvokeLogCycleDto.getLocalSystem();
        Integer logSaveCycle = interfaceInvokeLogCycleDto.getLogSaveCycle();
        String cycleUnit = interfaceInvokeLogCycleDto.getCycleUnit();
        Validate.notNull((Object)localSystem, (String)"\u53d8\u66f4\u65e5\u5fd7\u5468\u671f\u65f6 \u5bf9\u5e94\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)logSaveCycle, (String)"\u53d8\u66f4\u65e5\u5fd7\u5468\u671f\u65f6 \u65e5\u5fd7\u4fdd\u5b58\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((logSaveCycle >= 1 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u5468\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1", (Object[])new Object[0]);
        Validate.notNull((Object)cycleUnit, (String)"\u53d8\u66f4\u65e5\u5fd7\u5468\u671f\u65f6 \u65e5\u5fd7\u4fdd\u5b58\u5468\u671f\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LogSaveCycleUnitEnum enumByKey = LogSaveCycleUnitEnum.findEnumByKey((String)cycleUnit);
        Validate.notNull((Object)enumByKey, (String)"\u65e5\u5fd7\u4fdd\u5b58\u5468\u671f\u5355\u4f4d\u4e0d\u662f\u6709\u6548\u7684\u5355\u4f4d \u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        List<InterfaceInvokeLogCycle> interfaceInvokeLogCycles = this.interfaceInvokeLogCycleRepository.findByTargetSystem(localSystem);
        if (CollectionUtils.isEmpty(interfaceInvokeLogCycles)) {
            InterfaceInvokeLogCycle interfaceInvokeLogCycle2 = new InterfaceInvokeLogCycle();
            interfaceInvokeLogCycle2.setTargetSystem(localSystem);
            interfaceInvokeLogCycle2.setLogSaveCycle(logSaveCycle);
            interfaceInvokeLogCycle2.setCycleUnit(cycleUnit);
            this.interfaceInvokeLogCycleRepository.saveAndFlush((Object)interfaceInvokeLogCycle2);
        } else {
            interfaceInvokeLogCycles.forEach(interfaceInvokeLogCycle -> {
                interfaceInvokeLogCycle.setTargetSystem(localSystem);
                interfaceInvokeLogCycle.setLogSaveCycle(logSaveCycle);
                interfaceInvokeLogCycle.setCycleUnit(cycleUnit);
                this.interfaceInvokeLogCycleRepository.saveAllAndFlush(interfaceInvokeLogCycles);
            });
        }
    }

    @Override
    public List<InterfaceInvokeLogCycle> findByApplicationName(String sourceSysName) {
        Validate.notNull((Object)sourceSysName, (String)"\u6839\u636e\u7cfb\u7edf\u670d\u52a1\u540d\u79f0\u67e5\u8be2\u914d\u7f6e\u65f6\uff0c\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<InterfaceInvokeLogCycle> interfaceInvokeLogCycles = this.interfaceInvokeLogCycleRepository.findByTargetSystem(sourceSysName);
        if (CollectionUtils.isEmpty(interfaceInvokeLogCycles)) {
            return new ArrayList<InterfaceInvokeLogCycle>(0);
        }
        return interfaceInvokeLogCycles;
    }

    @Override
    public InterfaceLogSaveCycleVo findLogSaveCycleByLocalSystem(String localSystem) {
        Validate.notNull((Object)localSystem, (String)"\u670d\u52a1\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<InterfaceInvokeLogCycle> interfaceInvokeLogCycles = this.interfaceInvokeLogCycleRepository.findByTargetSystem(localSystem);
        InterfaceLogSaveCycleVo interfaceLogSaveCycleVo = new InterfaceLogSaveCycleVo();
        if (CollectionUtils.isEmpty(interfaceInvokeLogCycles)) {
            return interfaceLogSaveCycleVo;
        }
        InterfaceInvokeLogCycle interfaceInvokeLogCycle = interfaceInvokeLogCycles.get(0);
        interfaceLogSaveCycleVo.setId(interfaceInvokeLogCycle.getId());
        interfaceLogSaveCycleVo.setLogSaveCycle(interfaceInvokeLogCycle.getLogSaveCycle());
        interfaceLogSaveCycleVo.setCycleUnit(interfaceInvokeLogCycle.getCycleUnit());
        return interfaceLogSaveCycleVo;
    }
}

