/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.service.internal;

import com.bizunited.nebula.common.entity.UuidEntity;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.monitor.local.entity.InterfaceInvokeLogCycle;
import com.bizunited.nebula.monitor.local.entity.InterfaceInvokeMonitor;
import com.bizunited.nebula.monitor.local.repository.InterfaceInvokeLogCycleRepository;
import com.bizunited.nebula.monitor.local.repository.InterfaceInvokeMonitorRepository;
import com.bizunited.nebula.monitor.local.service.InterfaceInvokeMonitorService;
import com.bizunited.nebula.monitor.rest.utils.UrlValidateUtils;
import com.bizunited.nebula.monitor.sdk.constants.InterfaceInvokeMonitorConstant;
import com.bizunited.nebula.monitor.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.monitor.sdk.enums.LogSaveCycleUnitEnum;
import com.bizunited.nebula.monitor.sdk.vo.InterfaceInvokeMonitorVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Service(value="InterfaceInvokeMonitorService")
public class InterfaceInvokeMonitorServiceImpl
implements InterfaceInvokeMonitorService {
    @Autowired
    private InterfaceInvokeMonitorRepository interfaceInvokeMonitorRepository;
    @Autowired
    private InterfaceInvokeLogCycleRepository interfaceInvokeLogCycleRepository;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    @Override
    @Transactional
    public void create(InterfaceInvokeMonitor interfaceInvokeMonitor) {
        this.createOrUpdateValidate(interfaceInvokeMonitor, null);
        interfaceInvokeMonitor.setTenantCode(TenantUtils.getTenantCode());
        interfaceInvokeMonitor.setEnableStatus(EnableStatusEnum.ENABLE.getDictCode());
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        String name = authentication.getName();
        interfaceInvokeMonitor.setCreateAccount(name);
        interfaceInvokeMonitor.setCreateTime(new Date());
        interfaceInvokeMonitor.setModifyAccount(name);
        interfaceInvokeMonitor.setModifyTime(new Date());
        InterfaceInvokeLogCycle interfaceInvokeLogCycle = new InterfaceInvokeLogCycle();
        interfaceInvokeLogCycle.setTargetSystem(interfaceInvokeMonitor.getLocalSystem());
        interfaceInvokeLogCycle.setLogSaveCycle(InterfaceInvokeMonitorConstant.LOG_CYCLE_DEFAULT);
        interfaceInvokeLogCycle.setCycleUnit(LogSaveCycleUnitEnum.DAY.getCode());
        List<InterfaceInvokeLogCycle> interfaceInvokeLogCycles = this.interfaceInvokeLogCycleRepository.findByTargetSystem(interfaceInvokeMonitor.getLocalSystem());
        if (CollectionUtils.isEmpty(interfaceInvokeLogCycles)) {
            this.interfaceInvokeLogCycleRepository.save((Object)interfaceInvokeLogCycle);
        }
        this.interfaceInvokeMonitorRepository.saveAndFlush((Object)interfaceInvokeMonitor);
    }

    @Override
    @Transactional
    public void update(InterfaceInvokeMonitor interfaceInvokeMonitor) {
        String id = interfaceInvokeMonitor.getId();
        InterfaceInvokeMonitor interfaceInvokeMonitorOld = this.interfaceInvokeMonitorRepository.findDetailById(id);
        Validate.notNull((Object)((Object)interfaceInvokeMonitorOld), (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5f97\u6570\u636e", (Object[])new Object[0]);
        this.createOrUpdateValidate(interfaceInvokeMonitor, id);
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        String name = authentication.getName();
        interfaceInvokeMonitor.setTenantCode(TenantUtils.getTenantCode());
        interfaceInvokeMonitor.setCreateAccount(interfaceInvokeMonitorOld.getCreateAccount());
        interfaceInvokeMonitor.setCreateTime(interfaceInvokeMonitorOld.getCreateTime());
        interfaceInvokeMonitor.setModifyAccount(name);
        interfaceInvokeMonitor.setModifyTime(new Date());
        interfaceInvokeMonitor.setEnableStatus(interfaceInvokeMonitorOld.getEnableStatus());
        this.interfaceInvokeMonitorRepository.deleteById(id);
        this.interfaceInvokeMonitorRepository.saveAndFlush((Object)interfaceInvokeMonitor);
    }

    @Override
    @Transactional
    public void deleteBatchByIds(List<String> ids) {
        Validate.notNull(ids, (String)"\u6267\u884c\u5220\u9664\u64cd\u4f5c\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set idSet = ids.stream().collect(Collectors.toSet());
        List interfaceInvokeMonitors = this.interfaceInvokeMonitorRepository.findAllById(idSet);
        Validate.notNull((Object)interfaceInvokeMonitors, (String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u6570\u636e", (Object[])new Object[0]);
        Set realIds = interfaceInvokeMonitors.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        this.interfaceInvokeMonitorRepository.deleteAllById(realIds);
    }

    @Override
    public InterfaceInvokeMonitor findDetailById(String id) {
        Validate.notNull((Object)id, (String)"\u67e5\u8be2\u8be6\u60c5\u65f6id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InterfaceInvokeMonitor interfaceInvokeMonitor = this.interfaceInvokeMonitorRepository.findById(id).orElse(null);
        return interfaceInvokeMonitor;
    }

    @Override
    public Page<InterfaceInvokeMonitorVo> findByConditions(Pageable pageable, InterfaceInvokeMonitor interfaceInvokeMonitor) {
        Page<InterfaceInvokeMonitorVo> page;
        if (interfaceInvokeMonitor == null) {
            interfaceInvokeMonitor = new InterfaceInvokeMonitor();
        }
        if (Objects.isNull(page = this.interfaceInvokeMonitorRepository.findByConditions(pageable, interfaceInvokeMonitor))) {
            return new PageImpl(new ArrayList());
        }
        return page;
    }

    @Override
    @Transactional
    public void enableBatch(Set<String> ids) {
        Validate.notNull(ids, (String)"\u6279\u91cf\u542f\u7528\u65f6\u4e3b\u952e\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<InterfaceInvokeMonitor> interfaceInvokeMonitors = this.interfaceInvokeMonitorRepository.findAllById(ids);
        Validate.notNull((Object)interfaceInvokeMonitors, (String)"\u672a\u67e5\u8be2\u5230\u6240\u9009\u4e3b\u952e\u5bf9\u5e94\u5f97\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[0]);
        interfaceInvokeMonitors = interfaceInvokeMonitors.stream().filter(interfaceInvokeMonitor -> EnableStatusEnum.DISABLE.getDictCode().equals(interfaceInvokeMonitor.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(interfaceInvokeMonitors)) {
            return;
        }
        Set oldIds = interfaceInvokeMonitors.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        this.interfaceInvokeMonitorRepository.deleteAllById(oldIds);
        this.interfaceInvokeMonitorRepository.flush();
        interfaceInvokeMonitors.forEach(interfaceInvokeMonitor -> interfaceInvokeMonitor.setEnableStatus(EnableStatusEnum.ENABLE.getDictCode()));
        this.interfaceInvokeMonitorRepository.saveAllAndFlush(interfaceInvokeMonitors);
    }

    @Override
    @Transactional
    public void disableBatch(Set<String> ids) {
        Validate.notNull(ids, (String)"\u6279\u91cf\u7981\u7528\u65f6\u4e3b\u952e\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<InterfaceInvokeMonitor> interfaceInvokeMonitors = this.interfaceInvokeMonitorRepository.findAllById(ids);
        Validate.notNull((Object)interfaceInvokeMonitors, (String)"\u672a\u67e5\u8be2\u5230\u6240\u9009\u4e3b\u952e\u5bf9\u5e94\u5f97\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[0]);
        interfaceInvokeMonitors = interfaceInvokeMonitors.stream().filter(interfaceInvokeMonitor -> EnableStatusEnum.ENABLE.getDictCode().equals(interfaceInvokeMonitor.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(interfaceInvokeMonitors)) {
            return;
        }
        Set oldIds = interfaceInvokeMonitors.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        this.interfaceInvokeMonitorRepository.deleteAllById(oldIds);
        this.interfaceInvokeMonitorRepository.flush();
        interfaceInvokeMonitors.forEach(interfaceInvokeMonitor -> interfaceInvokeMonitor.setEnableStatus(EnableStatusEnum.DISABLE.getDictCode()));
        this.interfaceInvokeMonitorRepository.saveAllAndFlush(interfaceInvokeMonitors);
    }

    @Override
    public List<InterfaceInvokeMonitor> findByTargetAndSourceNameAndUrl(String targetSysName, String sourceSysName, String url, String requestMethod) {
        if (StringUtils.isNotBlank((CharSequence)targetSysName) && StringUtils.isNotBlank((CharSequence)sourceSysName) && StringUtils.isNotBlank((CharSequence)url) && StringUtils.isNotBlank((CharSequence)requestMethod)) {
            String tenantCode = TenantUtils.getTenantCode();
            List<InterfaceInvokeMonitor> interfaceInvokeMonitors = this.interfaceInvokeMonitorRepository.findByTargetAndSourceNameAndUrl(targetSysName, sourceSysName, url, requestMethod, tenantCode);
            return interfaceInvokeMonitors;
        }
        return new ArrayList<InterfaceInvokeMonitor>(0);
    }

    private void createOrUpdateValidate(InterfaceInvokeMonitor interfaceInvokeMonitor, String id) {
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notNull((Object)((Object)interfaceInvokeMonitor), (String)"\u65b0\u589e\u6216\u7f16\u8f91\u65f6\uff0c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String urlPath = interfaceInvokeMonitor.getUrlPath();
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)urlPath), (String)"\u65b0\u589e\u6216\u7f16\u8f91\u65f6\uff0curl\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String remark = interfaceInvokeMonitor.getRemark();
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)remark), (String)"\u65b0\u589e\u6216\u7f16\u8f91\u65f6\uff0c\u63a5\u53e3\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String fromSystem = interfaceInvokeMonitor.getFromSystem();
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)fromSystem), (String)"\u65b0\u589e\u6216\u7f16\u8f91\u65f6\uff0c\u6765\u6e90\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Pattern pattern = Pattern.compile("[\\u4e00-\\u9fa5\uff0c\u3002\uff01\uff1f\uff1b\uff1a\u201c\u201d\u2018\u2019\uff08\uff09\u300a\u300b\u3010\u3011]+");
        Matcher matcher = pattern.matcher(fromSystem);
        if (matcher.find()) {
            Validate.isTrue((boolean)false, (String)"\u8bf7\u6c42\u5934\u6807\u8bc6\u4e0d\u652f\u6301\u4e2d\u6587\u5b57\u7b26\u6216\u4e2d\u6587\u9017\u53f7", (Object[])new Object[0]);
        }
        Validate.notNull((Object)interfaceInvokeMonitor.getFromSystemDesc(), (String)"\u65b0\u589e\u6216\u7f16\u8f91\u65f6\uff0c\u6765\u6e90\u7cfb\u7edf\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String methods = interfaceInvokeMonitor.getMethods();
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)methods), (String)"\u65b0\u589e\u6216\u7f16\u8f91\u65f6\uff0c\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<InterfaceInvokeMonitor> interfaceInvokeMonitorByUrl = this.interfaceInvokeMonitorRepository.findByUrl(urlPath, fromSystem, tenantCode);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            interfaceInvokeMonitorByUrl = interfaceInvokeMonitorByUrl.stream().filter(monitor -> !Objects.equals(monitor.getId(), id)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(interfaceInvokeMonitorByUrl)) {
            methods = StringUtils.upperCase((String)methods);
            String[] methodArray = methods.split(",");
            Set methodSet = Arrays.stream(methodArray).collect(Collectors.toSet());
            for (InterfaceInvokeMonitor interfaceInvoke : interfaceInvokeMonitorByUrl) {
                String method = interfaceInvoke.getMethods();
                if (StringUtils.isBlank((CharSequence)method)) continue;
                method = StringUtils.upperCase((String)method);
                String[] methodArrayOld = method.split(",");
                Set methodSetOld = Arrays.stream(methodArrayOld).collect(Collectors.toSet());
                Validate.isTrue((boolean)Collections.disjoint(methodSet, methodSetOld), (String)("url\u5730\u5740\u540c\u7b49\u7ef4\u5ea6\u4e0b\u6709\u91cd\u53e0:" + urlPath), (Object[])new Object[0]);
            }
        }
        String localSystem = interfaceInvokeMonitor.getLocalSystem();
        this.validateUrl(urlPath, localSystem);
    }

    private void validateUrl(String urlPath, String localSystem) {
        Boolean result = UrlValidateUtils.buildUrlValidate(urlPath, localSystem, this.requestMappingHandlerMapping);
        Validate.isTrue((boolean)result, (String)"url\u5730\u5740\u4e0d\u662f\u6709\u6548\u7684\u8def\u5f84\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }
}

