/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.service.internal;

import com.bizunited.nebula.monitor.local.dto.LogInfoConditionDto;
import com.bizunited.nebula.monitor.local.elasticsearch.modle.LogInfo;
import com.bizunited.nebula.monitor.local.service.InterfaceInvokeLogCycleService;
import com.bizunited.nebula.monitor.local.service.LogInfoEsService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class LogInfoEsServiceImpl
implements LogInfoEsService {
    @Autowired
    private ElasticsearchRestTemplate elasticsearchRestTemplate;
    @Autowired
    private InterfaceInvokeLogCycleService interfaceInvokeLogCycleService;

    @Override
    public Page<LogInfo> findByConditions(LogInfoConditionDto condition, Pageable pageable) {
        if (condition == null) {
            condition = new LogInfoConditionDto();
        }
        Integer invokeType = condition.getInvokeType();
        Validate.notNull((Object)invokeType, (String)"es\u65e5\u5fd7\u5206\u9875\u67e5\u8be2\u65f6\uff0c\u63a5\u6536\u6216\u53d1\u9001\u65e5\u5fd7\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)condition.getLogId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)condition.getLogId()).field("logId"));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getSysName())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"sysName", (Object)condition.getSysName()));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getSysDesc())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"sysDesc", (String)("*" + condition.getSysDesc() + "*")));
        }
        if (condition.getRequestTimeStart() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"requestTime").gte((Object)condition.getRequestTimeStart().getTime()));
        }
        if (condition.getRequestTimeEnd() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"requestTime").lte((Object)condition.getRequestTimeEnd().getTime()));
        }
        if (condition.getInvokeType() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"invokeType", (Object)condition.getInvokeType()));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getTargetDomain())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"targetDomain", (Object)condition.getTargetDomain()));
        }
        if (condition.getResponseTimeStart() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"responseTime").gte((Object)condition.getResponseTimeStart().getTime()));
        }
        if (condition.getResponseTimeEnd() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"responseTime").lte((Object)condition.getResponseTimeEnd().getTime()));
        }
        if (condition.getSourceSysName() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"sourceSysName", (Object)condition.getSourceSysName()));
        }
        if (condition.getTargetSysName() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"targetSysName", (Object)condition.getTargetSysName()));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getResponseStatusCode())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"responseStatusCode", (Object)condition.getResponseStatusCode()));
        }
        if ("200".equals(condition.getResponseStatus())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"responseStatusCode", (Object)200)).should((QueryBuilder)QueryBuilders.matchQuery((String)"responseStatusCode", (Object)0)));
        } else if ("201".equals(condition.getResponseStatus())) {
            queryBuilder.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"responseStatusCode", (Object)200)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"responseStatusCode", (Object)0));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getTargetPath())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"targetPath.keyword", (String)("*" + condition.getTargetPath() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getRequestParam())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"requestParam.keyword", (String)("*" + condition.getRequestParam() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getRequestBody())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"requestBody.keyword", (String)("*" + condition.getRequestBody() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getResponseBody())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"responseBody.keyword", (String)("*" + condition.getResponseBody() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getContent())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)condition.getContent(), (String[])new String[]{"requestParam", "requestHeaders", "requestBody", "responseBody", "responseCookies", "responseHeaders"}));
        }
        NativeSearchQuery nativeSearchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)queryBuilder).withPageable(pageable).withSorts(new SortBuilder[]{SortBuilders.fieldSort((String)"requestTime").order(SortOrder.DESC)}).build();
        SearchHits search = this.elasticsearchRestTemplate.search((Query)nativeSearchQuery, LogInfo.class);
        List data = search.stream().map(SearchHit::getContent).collect(Collectors.toList());
        return new PageImpl(data, pageable, search.getTotalHits());
    }
}

