/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.rest.service.Impl;

import com.bizunited.nebula.monitor.rest.config.RestMonitorAutoConfiguration;
import com.bizunited.nebula.monitor.rest.service.MonitorRestTemplateService;
import com.bizunited.nebula.monitor.rest.template.MonitorRestTemplate;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Service;

@Service
public class MonitorRestTemplateServiceImpl
implements MonitorRestTemplateService {
    private static final Logger log = LoggerFactory.getLogger(MonitorRestTemplateServiceImpl.class);
    private static MonitorRestTemplate monitorRestTemplate = null;
    @Autowired
    private RestMonitorAutoConfiguration restMonitorAutoConfiguration;
    private static ConnectionPool CONN_POOL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitorRestTemplate getRestTemplate() {
        if (monitorRestTemplate != null) {
            return monitorRestTemplate;
        }
        Class<MonitorRestTemplateServiceImpl> clazz = MonitorRestTemplateServiceImpl.class;
        synchronized (MonitorRestTemplateServiceImpl.class) {
            if (monitorRestTemplate != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return monitorRestTemplate;
            }
            OkHttpClient okHttpClient = this.getOkHttpClientBuilder().build();
            log.debug("\u521b\u5efaOkHttp\u5ba2\u6237\u7aef");
            OkHttp3ClientHttpRequestFactory okHttp3ClientHttpRequestFactory = new OkHttp3ClientHttpRequestFactory(okHttpClient);
            monitorRestTemplate = this.getMonitorRestTemplate(okHttp3ClientHttpRequestFactory);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return monitorRestTemplate;
        }
    }

    private MonitorRestTemplate getMonitorRestTemplate(OkHttp3ClientHttpRequestFactory okHttp3ClientHttpRequestFactory) {
        log.debug("\u521b\u5efaBufferClientHttpRequestFactory\u5ba2\u6237\u7aef\uff0c\u65b9\u4fbf\u4ece\u6d41\u4e2d\u83b7\u53d6\u7ed3\u679c");
        BufferingClientHttpRequestFactory bufferingClientHttpRequestFactory = new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)okHttp3ClientHttpRequestFactory);
        MonitorRestTemplate monitorRestTemplate = new MonitorRestTemplate((ClientHttpRequestFactory)bufferingClientHttpRequestFactory);
        monitorRestTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return monitorRestTemplate;
    }

    private OkHttpClient.Builder getOkHttpClientBuilder() {
        int cacheSize = 0xA00000;
        Cache cache = null;
        try {
            File createTempFile = File.createTempFile("tutu_OkHttpCache_", ".tmp");
            cache = new Cache(createTempFile, (long)cacheSize);
            createTempFile.deleteOnExit();
        }
        catch (Exception createTempFile) {
            // empty catch block
        }
        if (CONN_POOL == null) {
            int rest_max_idle_connections = this.restMonitorAutoConfiguration.REST_MAX_IDLE_CONNECTIONS;
            Long rest_keep_alive_duration = this.restMonitorAutoConfiguration.REST_KEEP_ALIVE_DURATION;
            CONN_POOL = new ConnectionPool(rest_max_idle_connections, rest_keep_alive_duration.longValue(), TimeUnit.SECONDS);
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.cache(cache);
        builder.connectionPool(CONN_POOL);
        builder.connectTimeout(this.restMonitorAutoConfiguration.REST_CONNECT_TIMEOUT.longValue(), TimeUnit.MILLISECONDS);
        builder.readTimeout(this.restMonitorAutoConfiguration.REST_READ_TIMEOUT.longValue(), TimeUnit.MILLISECONDS);
        builder.writeTimeout(this.restMonitorAutoConfiguration.REST_WRITE_TIMEOUT.longValue(), TimeUnit.MILLISECONDS);
        return builder;
    }
}

