/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.rest.utils;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class HttpRequestUtils {
    public static MultiValueMap<String, String> buildQueryParamsMap(HttpRequest httpRequest) {
        LinkedMultiValueMap queryParamMapping = new LinkedMultiValueMap();
        URI uri = httpRequest.getURI();
        String query = uri.getQuery();
        if (query == null) {
            return queryParamMapping;
        }
        if (query.contains("=")) {
            String[] paramArray;
            for (String param : paramArray = query.split("&")) {
                String[] row = param.split("=");
                queryParamMapping.add((Object)row[0], (Object)row[1]);
            }
        } else if (!query.contains("=")) {
            queryParamMapping.add((Object)"", (Object)query);
        }
        return queryParamMapping;
    }

    public static List<String> buildQueryParams(HttpRequest httpRequest) {
        ArrayList queryParamValues = Lists.newArrayList();
        MultiValueMap<String, String> queryParamMapping = HttpRequestUtils.buildQueryParamsMap(httpRequest);
        for (Map.Entry row : queryParamMapping.entrySet()) {
            List value = (List)row.getValue();
            if (value.size() > 1) {
                queryParamValues.add(StringUtils.join((Object[])new Object[]{row.getKey(), "=", value}));
                continue;
            }
            queryParamValues.add(StringUtils.join((Object[])new String[]{(String)row.getKey(), "=", (String)value.get(0)}));
        }
        return queryParamValues;
    }

    public static List<String> buildHeaderParams(HttpHeaders httpHeaders) {
        ArrayList headerParamValues = Lists.newArrayList();
        for (Map.Entry httpHeaderItem : httpHeaders.entrySet()) {
            String headerName = (String)httpHeaderItem.getKey();
            List headerValues = (List)httpHeaderItem.getValue();
            if (CollectionUtils.isEmpty((Collection)headerValues)) continue;
            for (String headerValue : headerValues) {
                headerParamValues.add(StringUtils.join((Object[])new String[]{headerName, "=", headerValue, ";", System.lineSeparator()}));
            }
        }
        return headerParamValues;
    }
}

