/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.rest.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class UrlValidateUtils {
    private static final Logger log = LoggerFactory.getLogger(UrlValidateUtils.class);

    public static Boolean buildUrlValidate(String requestURI, String contextPath, RequestMappingHandlerMapping requestMappingHandlerMapping) {
        if (StringUtils.isBlank((CharSequence)requestURI)) {
            log.error("\u672a\u83b7\u53d6\u5230url\u8def\u5f84!");
            return false;
        }
        contextPath = contextPath.toLowerCase();
        String resolveLookUpPath = UrlValidateUtils.getPath(requestURI, contextPath);
        Map handlerMethods = requestMappingHandlerMapping.getHandlerMethods();
        for (Map.Entry handlerMethodEntry : handlerMethods.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)handlerMethodEntry.getKey();
            Set directPaths = requestMappingInfo.getDirectPaths();
            if (!directPaths.contains(resolveLookUpPath)) continue;
            log.info("requestMappingInfo ===>{}", (Object)requestMappingInfo);
            return true;
        }
        return false;
    }

    private static String getPath(String url, String contextPath) {
        String tempUrl = url.toLowerCase().startsWith("http") ? url : (url.startsWith("/") ? "http://127.0.0.1" + url : "http://127.0.0.1/" + url);
        String resolvedLookUpPath = null;
        try {
            URL urlObj = new URL(tempUrl);
            resolvedLookUpPath = urlObj.getPath();
        }
        catch (MalformedURLException e) {
            Validate.isTrue((boolean)false, (String)"URL\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff0c%s", (Object[])new Object[]{url});
        }
        if (resolvedLookUpPath.startsWith(contextPath)) {
            resolvedLookUpPath = resolvedLookUpPath.substring(contextPath.length());
        }
        return resolvedLookUpPath;
    }
}

