/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.IpUtils;
import com.bizunited.nebula.monitor.sdk.bo.Cpu;
import com.bizunited.nebula.monitor.sdk.bo.Disk;
import com.bizunited.nebula.monitor.sdk.bo.Memory;
import com.bizunited.nebula.monitor.sdk.bo.MonitorAllBo;
import com.bizunited.nebula.monitor.sdk.service.MonitorService;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/monitor"})
public class MonitorController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorController.class);
    @Autowired
    private MonitorService monitorService;

    @ApiOperation(value="\u67e5\u8be2\u5728\u5f53\u524d\u8282\u70b9\u7684CPU\u4f7f\u7528\u60c5\u51b5")
    @GetMapping(value={""})
    public ResponseModel all() {
        MonitorAllBo all = null;
        try {
            all = this.monitorService.getAll();
            ResponseModel result = this.buildHttpResultW(all, new String[0]);
            result.setMessage(IpUtils.findInternalIp());
            return result;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5728\u5f53\u524d\u8282\u70b9\u7684CPU\u4f7f\u7528\u60c5\u51b5")
    @GetMapping(value={"/cpu"})
    public ResponseModel cpu() {
        Cpu cpu = null;
        try {
            cpu = this.monitorService.getCpu();
            ResponseModel result = this.buildHttpResultW(cpu, new String[0]);
            result.setMessage(IpUtils.findInternalIp());
            return result;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5728\u5f53\u524d\u8282\u70b9\u7684\u5185\u5b58\u4f7f\u7528\u60c5\u51b5")
    @GetMapping(value={"/memory"})
    public ResponseModel memory() {
        Memory memory = null;
        try {
            memory = this.monitorService.getMemory();
            ResponseModel result = this.buildHttpResultW(memory, new String[0]);
            result.setMessage(IpUtils.findInternalIp());
            return result;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5728\u5f53\u524d\u8282\u70b9\u7684\u78c1\u76d8\u4f7f\u7528\u60c5\u51b5")
    @GetMapping(value={"disk"})
    public ResponseModel disk() {
        Disk disk = null;
        try {
            disk = this.monitorService.getDisk();
            ResponseModel result = this.buildHttpResultW(disk, new String[0]);
            result.setMessage(IpUtils.findInternalIp());
            return result;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

