/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.repository.Impl;

import com.bizunited.nebula.common.repository.PageRepositoryImpl;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.monitor.local.entity.InterfaceInvokeMonitor;
import com.bizunited.nebula.monitor.local.repository.InterfaceInvokeMonitorConditionsRepository;
import com.bizunited.nebula.monitor.sdk.vo.InterfaceInvokeMonitorVo;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="_InterfaceInvokeMonitorConditionsRepositoryImpl")
public class InterfaceInvokeMonitorConditionsRepositoryImpl
implements InterfaceInvokeMonitorConditionsRepository,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<InterfaceInvokeMonitorVo> findByConditions(Pageable pageable, InterfaceInvokeMonitor interfaceInvokeMonitor) {
        String remark;
        String urlPath;
        String enableStatus;
        if (interfaceInvokeMonitor == null) {
            interfaceInvokeMonitor = new InterfaceInvokeMonitor();
        }
        StringBuilder hql = new StringBuilder(" select  imm.tenant_code as tenantCode, imm.enable_status as enableStatus, imm.remark as remark, imm.from_system as fromSystem, imm.from_system_desc as fromSystemDesc, imm.local_system as localSystem, imm.methods as methods, imm.url_path as urlPath, imm.create_account as createAccount, imm.create_time as createTime, imm.modify_account as modifyAccount, imm.modify_time as modifyTime, imm.id as id, imc.log_save_cycle as logSaveCycle, imc.cycle_unit as cycleUnit from interface_invoke_monitor imm  left join interface_invoke_log_cycle imc on imc.target_system = imm.local_system where 1 = 1");
        StringBuilder countHql = new StringBuilder("select count(*) from interface_invoke_monitor imm left join interface_invoke_log_cycle imc on imc.target_system = imm.local_system  where 1 = 1");
        StringBuilder conditions = new StringBuilder();
        HashMap<String, String> parameters = new HashMap<String, String>();
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            conditions.append(" AND imm.tenant_code = :tenantCode");
            parameters.put("tenantCode", tenantCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(enableStatus = interfaceInvokeMonitor.getEnableStatus()))) {
            conditions.append(" AND imm.enable_status = :enableStatus");
            parameters.put("enableStatus", enableStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)(urlPath = interfaceInvokeMonitor.getUrlPath()))) {
            conditions.append(" AND imm.url_path like CONCAT('%',:urlPath,'%')");
            parameters.put("urlPath", urlPath);
        }
        if (StringUtils.isNotBlank((CharSequence)(remark = interfaceInvokeMonitor.getRemark()))) {
            conditions.append(" AND imm.remark like CONCAT('%',:remark,'%')");
            parameters.put("remark", remark);
        }
        hql.append((CharSequence)conditions).append(" order by imm.create_time desc");
        countHql.append((CharSequence)conditions);
        int pageNumber = pageable.getPageNumber();
        int pageSize = pageable.getPageSize();
        pageable = pageNumber > 0 ? PageRequest.of((int)(pageNumber - 1), (int)pageSize) : PageRequest.of((int)0, (int)pageSize);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, true, InterfaceInvokeMonitorVo.class);
    }
}

