/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.monitor.local.config.MonitorProperties;
import com.bizunited.nebula.monitor.local.model.AuthInterfaceModel;
import com.bizunited.nebula.monitor.local.repository.AuthInterfaceRepository;
import com.bizunited.nebula.monitor.local.service.AuthInterfaceService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class AuthInterfaceServiceImpl
implements AuthInterfaceService {
    private static final Logger log = LoggerFactory.getLogger(AuthInterfaceServiceImpl.class);
    @Autowired
    private AuthInterfaceRepository authInterfaceRepository;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private MonitorProperties monitorProperties;

    @Override
    public Boolean checkUrl(AuthInterfaceModel model) {
        Set authInterfaceModels = this.findAuthInterfaceUrls();
        authInterfaceModels = (Set)ObjectUtils.defaultIfNull(authInterfaceModels, (Object)Sets.newHashSet());
        Boolean result = Boolean.FALSE;
        for (AuthInterfaceModel authInterfaceModel : authInterfaceModels) {
            if (!Objects.equals(model.getInterfaceUrl(), authInterfaceModel.getInterfaceUrl()) || !Objects.equals(model.getRequestMethod(), authInterfaceModel.getRequestMethod())) continue;
            result = Boolean.TRUE;
        }
        return result;
    }

    private Set<AuthInterfaceModel> findAuthInterfaceUrls() {
        String mapName = String.join((CharSequence)":", this.monitorProperties.getApplicationName(), "REDIS_KEY_AUTH_INTERFACE", TenantUtils.getTenantCode());
        Boolean hasKey = this.redisTemplate.hasKey((Object)mapName);
        if (!Boolean.TRUE.equals(hasKey)) {
            double currentTimeMillis = System.currentTimeMillis();
            AuthInterfaceModel defaultModel = new AuthInterfaceModel();
            defaultModel.setInterfaceUrl("default_url");
            defaultModel.setRequestMethod(RequestMethod.POST.name());
            this.redisTemplate.opsForZSet().add((Object)mapName, (Object)JSON.toJSONString((Object)defaultModel), currentTimeMillis);
            this.redisTemplate.expire((Object)mapName, 1L, TimeUnit.MINUTES);
            List authInterfaces = this.authInterfaceRepository.findAll();
            if (CollectionUtils.isNotEmpty((Collection)authInterfaces)) {
                Set typedTuples = authInterfaces.stream().map(authInterface -> {
                    AuthInterfaceModel model = new AuthInterfaceModel();
                    model.setInterfaceUrl(authInterface.getInterfaceUrl());
                    model.setRequestMethod(authInterface.getRequestMethod());
                    return new DefaultTypedTuple((Object)JSON.toJSONString((Object)model), Double.valueOf(currentTimeMillis));
                }).collect(Collectors.toSet());
                this.redisTemplate.opsForZSet().add((Object)mapName, typedTuples);
            }
        }
        Set jsonSet = this.redisTemplate.opsForZSet().range((Object)mapName, 0L, -1L);
        jsonSet = (Set)ObjectUtils.defaultIfNull((Object)jsonSet, (Object)Sets.newHashSet());
        return jsonSet.stream().map(json -> (AuthInterfaceModel)JSON.parseObject((String)json, AuthInterfaceModel.class)).collect(Collectors.toSet());
    }
}

