/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.service.internal;

import com.bizunited.nebula.common.util.NebulaToolkitUtil;
import com.bizunited.nebula.monitor.local.config.MonitorProperties;
import com.bizunited.nebula.monitor.local.elasticsearch.modle.LogInfo;
import com.bizunited.nebula.monitor.local.elasticsearch.modle.LogInfoArchive;
import com.bizunited.nebula.monitor.local.elasticsearch.modle.repository.LogInfoArchiveEsRepository;
import com.bizunited.nebula.monitor.local.elasticsearch.modle.repository.LogInfoEsRepository;
import com.bizunited.nebula.monitor.local.entity.InterfaceInvokeLogCycle;
import com.bizunited.nebula.monitor.local.service.InterfaceInvokeLogCycleService;
import com.bizunited.nebula.monitor.local.service.LogInfoArchiveService;
import com.bizunited.nebula.monitor.sdk.enums.LogSaveCycleUnitEnum;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class LogInfoArchiveServiceImpl
implements LogInfoArchiveService {
    private static final Logger log = LoggerFactory.getLogger(LogInfoArchiveServiceImpl.class);
    @Autowired(required=false)
    private InterfaceInvokeLogCycleService interfaceInvokeLogCycleService;
    @Autowired(required=false)
    private MonitorProperties monitorProperties;
    @Autowired(required=false)
    private ElasticsearchRestTemplate elasticsearchRestTemplate;
    @Autowired(required=false)
    private LogInfoEsRepository logInfoEsRepository;
    @Autowired(required=false)
    private LogInfoArchiveEsRepository logInfoArchiveEsRepository;

    @Override
    public void archiveLog() {
        SearchHits search;
        List logInfoList;
        BoolQueryBuilder queryBuilder = this.buildBaseArchiveBuilder();
        NativeSearchQuery nativeSearchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)queryBuilder).withPageable((Pageable)PageRequest.of((int)0, (int)500)).build();
        log.info("\u5f00\u59cb\u5f52\u6863\u63a5\u53e3\u76d1\u63a7\u65e5\u5fd7\u6570\u636e,\u5f52\u6863\u6267\u884ces\u67e5\u8be2\u8bed\u53e5:{}", (Object)nativeSearchQuery.getQuery().toString());
        long archiveNumber = 0L;
        int i = 0;
        while (!CollectionUtils.isEmpty(logInfoList = (search = this.elasticsearchRestTemplate.search((Query)nativeSearchQuery, LogInfo.class)).stream().map(SearchHit::getContent).collect(Collectors.toList()))) {
            Collection logInfoArchiveList = NebulaToolkitUtil.copyCollectionByWhiteList(logInfoList, LogInfo.class, LogInfoArchive.class, (String[])new String[0]);
            this.logInfoArchiveEsRepository.saveAll(logInfoArchiveList);
            this.logInfoEsRepository.deleteAll(logInfoList);
            archiveNumber += (long)logInfoList.size();
            ++i;
        }
        log.info("\u7ed3\u675f\u5f52\u6863\u63a5\u53e3\u76d1\u63a7\u65e5\u5fd7\u6570\u636e,\u5f52\u6863\u603b\u662f\u6570\u636e:{}", (Object)archiveNumber);
    }

    private BoolQueryBuilder buildBaseArchiveBuilder() {
        String applicationName = this.monitorProperties.getApplicationName();
        List<InterfaceInvokeLogCycle> logCycles = this.interfaceInvokeLogCycleService.findByApplicationName(applicationName);
        int archiveDays = 30;
        if (CollectionUtils.isNotEmpty(logCycles)) {
            InterfaceInvokeLogCycle logCycle = logCycles.get(0);
            String cycleUnit = logCycle.getCycleUnit();
            Integer logSaveCycle = logCycle.getLogSaveCycle();
            if (LogSaveCycleUnitEnum.DAY.getCode().equals(cycleUnit) && Objects.nonNull(logSaveCycle) && logSaveCycle > 0) {
                archiveDays = logSaveCycle;
            } else if (LogSaveCycleUnitEnum.YEAR.getCode().equals(cycleUnit) && Objects.nonNull(logSaveCycle) && logSaveCycle > 0) {
                archiveDays = logSaveCycle * 365;
            }
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"requestTime").lte((Object)(System.currentTimeMillis() - (long)archiveDays * 24L * 60L * 60L * 1000L)));
        queryBuilder.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"invokeType", (Object)"1")).must((QueryBuilder)QueryBuilders.matchQuery((String)"sourceSysName", (Object)applicationName))).should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"invokeType", (Object)"2")).must((QueryBuilder)QueryBuilders.matchQuery((String)"targetSysName", (Object)applicationName))));
        return queryBuilder;
    }
}

