/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.rest.template;

import com.bizunited.nebula.monitor.rest.service.Impl.ClientHttpRequestInterceptorForLog;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class MonitorRestTemplate
extends RestTemplate {
    private static final Logger log = LoggerFactory.getLogger(MonitorRestTemplate.class);
    private static final ClientHttpRequestInterceptor LOG_REQUEST_INTERCEPTOR = new ClientHttpRequestInterceptorForLog();
    private static final ResponseErrorHandler ERROR_HANDLER = new DefaultResponseErrorHandler(){

        protected void handleError(ClientHttpResponse response, HttpStatus statusCode) throws IOException {
            int value = statusCode.value();
            switch (value) {
                case 400: {
                    log.error("\u5ba2\u6237\u7aef\u8bf7\u6c42\u7684\u8bed\u6cd5\u9519\u8bef {}", (Object)statusCode.toString());
                    break;
                }
                case 601: {
                    log.error("\u8bf7\u6c42\u8981\u6c42\u7528\u6237\u7684\u8eab\u4efd\u8ba4\u8bc1 {}", (Object)statusCode.toString());
                    break;
                }
                default: {
                    super.handleError(response, statusCode);
                }
            }
        }
    };

    public MonitorRestTemplate(ClientHttpRequestFactory clientHttpRequestFactory) {
        super(clientHttpRequestFactory);
        List interceptors = this.getInterceptors();
        interceptors.add(LOG_REQUEST_INTERCEPTOR);
        this.setErrorHandler(ERROR_HANDLER);
    }
}

