/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.rest.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKHttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"http");
    public static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = 60000L;
    private static final OkHttpClient okHttpClient;
    public static final MediaType MediaType_JSON_UTF8;
    public static final Charset Charset_UTF8;

    public static OkHttpClient getDefaultOkHttpClient() {
        return okHttpClient;
    }

    public static OkHttpClient.Builder getOkHttpClientBuilder() {
        int cacheSize = 0xA00000;
        Cache cache = null;
        try {
            File createTempFile = File.createTempFile("tutucall_OkHttpCache_", ".tmp");
            cache = new Cache(createTempFile, (long)cacheSize);
        }
        catch (IOException createTempFile) {
            // empty catch block
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.cache(cache);
        builder.readTimeout(60000L, TimeUnit.MILLISECONDS);
        builder.writeTimeout(60000L, TimeUnit.MILLISECONDS);
        return builder;
    }

    public static String post(String url, String bodyString) throws IOException {
        return OKHttpUtils.post(url, bodyString, null);
    }

    public static String post(String url, String bodyString, Map<String, String> headerMap) throws IOException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[POST] {}", (Object)url);
            LOGGER.info("[POST  data]  {}", (Object)bodyString);
        }
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType_JSON_UTF8);
        Request.Builder builder = OKHttpUtils.getRequestBuilder(headerMap);
        Request request = builder.url(url).post(body).build();
        Response response = okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            String bodyText = response.body().string();
            response.close();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Response data]  {}", (Object)bodyText);
            }
            return bodyText;
        }
        response.close();
        throw new IOException("Unexpected code" + response);
    }

    public static String post(String url, Map<String, String> paramsMap) throws IOException {
        return OKHttpUtils.post(url, paramsMap, null);
    }

    public static String post(String url, Map<String, String> paramsMap, Map<String, String> headerMap) throws IOException {
        FormBody.Builder builder = new FormBody.Builder(Charset_UTF8);
        for (Map.Entry<String, String> object : paramsMap.entrySet()) {
            builder.add(object.getKey(), object.getValue());
        }
        FormBody formBody = builder.build();
        builder = OKHttpUtils.getRequestBuilder(headerMap);
        Request request = builder.url(url).post((RequestBody)formBody).build();
        Response response = okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            String bodyText = response.body().string();
            response.close();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Response data]  {]", (Object)bodyText);
            }
            return bodyText;
        }
        response.close();
        throw new IOException("Unexpected code" + response);
    }

    public static String get(String url) throws IOException {
        return OKHttpUtils.get(url, null);
    }

    private static String get(String url, Map<String, String> paramsMap) throws IOException {
        return OKHttpUtils.get(url, paramsMap, null);
    }

    private static String get(String url, Map<String, String> paramsMap, Map<String, String> headerMap) throws IOException {
        Request.Builder builder;
        Request request;
        Response response;
        if (paramsMap != null && !paramsMap.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            paramsMap.forEach((key, value) -> {
                String urlParam = String.format("&%s=%s", key, value);
                stringBuilder.append(urlParam);
            });
            url = !url.contains("?") ? url + "?" + stringBuilder.deleteCharAt(0) : url + stringBuilder;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[GET]  {}", (Object)url);
        }
        if ((response = okHttpClient.newCall(request = (builder = OKHttpUtils.getRequestBuilder(headerMap)).url(url).get().build()).execute()).isSuccessful()) {
            ResponseBody responseBody = response.body();
            long contentLength = responseBody.contentLength();
            String bodyText = responseBody.string();
            response.close();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Response data]  {}", (Object)bodyText);
            }
            return bodyText;
        }
        response.close();
        throw new IOException("Unexpected code" + response);
    }

    private static Request.Builder getRequestBuilder(Map<String, String> headerMap) {
        Request.Builder builder = new Request.Builder();
        if (headerMap != null) {
            for (Map.Entry<String, String> header : headerMap.entrySet()) {
                builder.addHeader(header.getKey(), header.getValue());
            }
        }
        return builder;
    }

    static {
        MediaType_JSON_UTF8 = MediaType.parse((String)"application/json;charset=utf-8");
        Charset_UTF8 = Charset.forName("UTF-8");
        okHttpClient = OKHttpUtils.getOkHttpClientBuilder().build();
    }
}

