/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.config;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration
@EntityScan(basePackages={"com.bizunited.nebula.monitor.local.entity"})
@EnableJpaRepositories(basePackages={"com.bizunited.nebula.monitor.local.repository"})
@ComponentScan(basePackages={"com.bizunited.nebula.monitor"})
@EnableElasticsearchRepositories(basePackages={"com.bizunited.nebula.monitor.local.elasticsearch"})
public class MonitorAutoConfiguration {
    @Bean(value={"monitor_log_PersistenceThreadExecutor"})
    public ThreadPoolExecutor getPersistenceThreadExecutor(final ApplicationContext applicationContext) {
        ThreadPoolExecutor persistenceThreadExecutor = new ThreadPoolExecutor(10, 20, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100000), new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "log_persistenceThread_" + this.count.incrementAndGet());
                ClassLoader classLoader = applicationContext.getClassLoader();
                thread.setContextClassLoader(classLoader);
                thread.setDaemon(false);
                return thread;
            }
        });
        return persistenceThreadExecutor;
    }
}

