/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.controller;

import com.bizunited.nebula.common.controller.model.ResponseCode;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.monitor.local.dto.LogInfoConditionDto;
import com.bizunited.nebula.monitor.local.elasticsearch.modle.LogInfo;
import com.bizunited.nebula.monitor.local.elasticsearch.modle.repository.LogInfoEsRepository;
import com.bizunited.nebula.monitor.local.service.LogInfoEsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/monitor/logInfos"})
@Api(tags={"\u5168\u5c40\u65e5\u5fd7\u76d1\u63a7\u4e2d\u5fc3es\u65e5\u5fd7api\u63a5\u53e3"}, value="LogInfoEsController")
public class LogInfoEsController {
    private static final Logger log = LoggerFactory.getLogger(LogInfoEsController.class);
    @Autowired
    private LogInfoEsService logInfoEsService;
    @Autowired
    private LogInfoEsRepository logInfoEsRepository;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(LogInfoConditionDto logInfoConditionDto) {
        Pageable pageable = this.buildPageable(logInfoConditionDto);
        Page<LogInfo> logInfoPage = this.logInfoEsService.findByConditions(logInfoConditionDto, pageable);
        ResponseModel responseModel = new ResponseModel();
        responseModel.setData(logInfoPage);
        responseModel.setResponseCode(ResponseCode.E0);
        responseModel.setSuccess(Boolean.valueOf(true));
        return responseModel;
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/findById"})
    public ResponseModel findById(@RequestParam String id) {
        LogInfo logInfo = this.logInfoEsRepository.findById(id).orElse(null);
        ResponseModel responseModel = new ResponseModel();
        responseModel.setData((Object)logInfo);
        responseModel.setResponseCode(ResponseCode.E0);
        responseModel.setSuccess(Boolean.valueOf(true));
        return responseModel;
    }

    private Pageable buildPageable(LogInfoConditionDto logInfoConditionDto) {
        if (logInfoConditionDto == null) {
            return null;
        }
        Integer page = logInfoConditionDto.getPage() == 0 ? logInfoConditionDto.getPage() : logInfoConditionDto.getPage() - 1;
        Integer size = logInfoConditionDto.getSize();
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"requestTime"});
        PageRequest pageRequest = PageRequest.of((int)(page == null ? 0 : page), (int)(size == null ? 20 : size), (Sort)sort);
        return pageRequest;
    }
}

