/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.filter;

import com.bizunited.nebula.common.controller.model.ResponseCode;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.monitor.local.config.MonitorProperties;
import com.bizunited.nebula.monitor.local.model.AuthInterfaceModel;
import com.bizunited.nebula.monitor.local.service.AuthInterfaceRoleService;
import com.bizunited.nebula.monitor.local.service.AuthInterfaceService;
import com.bizunited.nebula.security.sdk.AuthenticationUserService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthInterfaceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthInterfaceFilter.class);
    @Autowired
    private AuthInterfaceService authInterfaceService;
    @Autowired
    private AuthInterfaceRoleService authInterfaceRoleService;
    @Autowired(required=false)
    private AuthenticationUserService authenticationUserService;
    @Autowired
    private MonitorProperties monitorProperties;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (Boolean.FALSE.equals(this.monitorProperties.getEnableAuthInterface())) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String contextPath = httpServletRequest.getContextPath();
        String requestURI = httpServletRequest.getRequestURI();
        if (requestURI.startsWith(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        AuthInterfaceModel model = new AuthInterfaceModel();
        model.setInterfaceUrl(requestURI);
        model.setRequestMethod(httpServletRequest.getMethod());
        Boolean checkUrl = this.authInterfaceService.checkUrl(model);
        if (Boolean.FALSE.equals(checkUrl)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        try {
            UserIdentity loginUser = this.authenticationUserService.getLoginUser();
            Validate.isTrue((boolean)Objects.nonNull(loginUser), (String)"\u672a\u6388\u6743\u8c03\u7528", (Object[])new Object[0]);
            String[] roleCodes = loginUser.getRoleCodes();
            Validate.isTrue((boolean)Objects.nonNull(roleCodes), (String)"\u672a\u6388\u6743\u8c03\u7528", (Object[])new Object[0]);
            List roleCodeList = Arrays.stream(roleCodes).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            Validate.notEmpty(roleCodeList, (String)"\u672a\u6388\u6743\u8c03\u7528", (Object[])new Object[0]);
            for (String roleCode : roleCodes) {
                if (Boolean.TRUE.equals(this.monitorProperties.getAutoAuthorization())) {
                    this.authInterfaceRoleService.autoAuthorization(roleCode, model);
                    continue;
                }
                Boolean checkRoleUrl = this.authInterfaceRoleService.checkRoleUrl(roleCode, model);
                Validate.isTrue((boolean)checkRoleUrl, (String)"\u672a\u6388\u6743\u8c03\u7528", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            this.write(httpServletResponse, e.getMessage());
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        super.destroy();
    }

    private void write(HttpServletResponse response, String msg) throws IOException {
        if (StringUtils.isBlank((CharSequence)msg)) {
            ResponseModel result = new ResponseModel(Long.valueOf(System.currentTimeMillis()), null, ResponseCode.E602, (Throwable)new IllegalAccessException("\u8d26\u53f7\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(JsonUtils.obj2JsonString((Object)result));
        } else {
            ResponseModel result = new ResponseModel(Long.valueOf(System.currentTimeMillis()), null, ResponseCode.E602, (Throwable)new IllegalAccessException(msg));
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(JsonUtils.obj2JsonString((Object)result));
        }
    }
}

