/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.filter;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.monitor.local.elasticsearch.modle.LogInfo;
import com.bizunited.nebula.monitor.local.elasticsearch.service.LogPersistenceService;
import com.bizunited.nebula.monitor.local.entity.InterfaceInvokeMonitor;
import com.bizunited.nebula.monitor.local.service.InterfaceInvokeMonitorService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Component
public class GlobalLogFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GlobalLogFilter.class);
    @Autowired
    private InterfaceInvokeMonitorService interfaceInvokeMonitorService;
    private static final ThreadLocal<LogInfo> LOG_INFO_LOCAL = new ThreadLocal();
    @Autowired
    private LogPersistenceService logPersistenceService;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        ContentCachingRequestWrapper cachingRequestWrapper = new ContentCachingRequestWrapper(httpServletRequest);
        ContentCachingResponseWrapper cachingResponseWrapper = new ContentCachingResponseWrapper(httpServletResponse);
        String receiptSysName = httpServletRequest.getHeader("receiptSysName");
        if (StringUtils.isNotBlank((CharSequence)receiptSysName)) {
            String contextPath = httpServletRequest.getContextPath();
            String requestURI = httpServletRequest.getRequestURI();
            if (requestURI.startsWith(contextPath)) {
                requestURI = requestURI.substring(contextPath.length());
            }
            if (contextPath.startsWith("/")) {
                contextPath = contextPath.substring(1);
            }
            try {
                String requestMethod = httpServletRequest.getMethod();
                List<InterfaceInvokeMonitor> interfaceInvokeMonitors = this.validateUrl(receiptSysName, contextPath, requestURI, requestMethod);
                if (!CollectionUtils.isEmpty(interfaceInvokeMonitors)) {
                    LogInfo logInfo = this.buildLogInfo(httpServletRequest, contextPath);
                    InterfaceInvokeMonitor interfaceInvokeMonitor = interfaceInvokeMonitors.get(0);
                    String remark = interfaceInvokeMonitor.getRemark();
                    logInfo.setSysDesc(remark);
                    String fromSystemDesc = interfaceInvokeMonitor.getFromSystemDesc();
                    logInfo.setSourceSysDesc(fromSystemDesc);
                    LOG_INFO_LOCAL.set(logInfo);
                    this.buildRequestLogInfo(httpServletRequest);
                    logInfo.setRequestTime(System.currentTimeMillis());
                    try {
                        filterChain.doFilter((ServletRequest)cachingRequestWrapper, (ServletResponse)cachingResponseWrapper);
                    }
                    finally {
                        logInfo.setResponseTime(System.currentTimeMillis());
                    }
                    long executeTime = logInfo.getResponseTime() - logInfo.getRequestTime();
                    logInfo.setExecuteTime(executeTime);
                    try {
                        byte[] contentAsByteArray = cachingRequestWrapper.getContentAsByteArray();
                        String requestBody = new String(contentAsByteArray, "UTF-8");
                        logInfo.setRequestBody(requestBody);
                    }
                    catch (Exception e) {
                        log.error("\u8bfb\u53d6\u8bf7\u6c42body\u5f02\u5e38:{}", (Object)e.getMessage());
                    }
                    this.buildResponseLogInfo(cachingResponseWrapper);
                    this.savaLogInfoToEs();
                    cachingResponseWrapper.copyBodyToResponse();
                }
                log.info("\u5f53\u524d\u8bf7\u6c42\u4e0d\u53d7\u9650\u5236 \u4e0d\u8fdb\u884c\u65e5\u5fd7\u8bb0\u5f55 \u5f53\u524d\u8bf7\u6c42\u5730\u5740:{}", (Object)requestURI);
                filterChain.doFilter(servletRequest, servletResponse);
            }
            catch (Exception e) {
                log.error("\u7b2c\u4e09\u65b9\u8bf7\u6c42\u5185\u90e8\u7cfb\u7edf\u65f6\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38:{}", (Object)e.getMessage());
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                LOG_INFO_LOCAL.remove();
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void savaLogInfoToEs() {
        LogInfo logInfo = LOG_INFO_LOCAL.get();
        if (logInfo == null) {
            return;
        }
        this.logPersistenceService.saveLogInfo(logInfo);
    }

    private void buildResponseLogInfo(ContentCachingResponseWrapper cachingResponseWrapper) throws IOException {
        Collection cookies;
        Collection headerNames;
        log.info("\u5f00\u59cb\u5904\u7406\u5f53\u524d\u8bf7\u6c42\u7684\u54cd\u5e94\u6570\u636e\uff01");
        LogInfo logInfo = LOG_INFO_LOCAL.get();
        if (logInfo == null) {
            log.info("\u5f53\u524d\u8bf7\u6c42\u7684\u54cd\u5e94\u6570\u636e\u5904\u7406\u5b8c\u6210\uff01");
            return;
        }
        String responseBody = new String(cachingResponseWrapper.getContentAsByteArray(), "UTF-8");
        logInfo.setResponseBody(responseBody);
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)responseBody);
        Object responseCode = jsonObject.get((Object)"responseCode");
        if (responseCode instanceof String) {
            String responseCodes = (String)responseCode;
            logInfo.setResponseStatusCode(Integer.valueOf(responseCodes));
        }
        if (responseCode instanceof Integer) {
            logInfo.setResponseStatusCode((Integer)responseCode);
        }
        if (Objects.isNull(responseCode)) {
            Object code = jsonObject.get((Object)"code");
            if (code instanceof String) {
                String responseCodes = (String)code;
                logInfo.setResponseStatusCode(Integer.valueOf(responseCodes));
            } else if (code instanceof Integer) {
                logInfo.setResponseStatusCode((Integer)code);
            }
        }
        if ((headerNames = cachingResponseWrapper.getHeaderNames()) != null) {
            LinkedMultiValueMap headerMap = new LinkedMultiValueMap();
            for (String headerName : headerNames) {
                String headerValue = cachingResponseWrapper.getHeader(headerName);
                headerMap.add((Object)headerName, (Object)headerValue);
            }
            logInfo.setResponseHeaders((MultiValueMap<String, String>)headerMap);
        }
        if ((cookies = cachingResponseWrapper.getHeaders("Set-Cookie")) != null) {
            logInfo.setResponseCookies(Lists.newArrayList((Iterable)cookies));
        }
        log.info("\u5f53\u524d\u8bf7\u6c42\u7684\u54cd\u5e94\u6570\u636e\u5904\u7406\u5b8c\u6210\uff01");
    }

    private void buildRequestLogInfo(HttpServletRequest httpServletRequest) {
        log.info("\u5f00\u59cb\u5904\u7406\u5f53\u524d\u8bf7\u6c42\u7684\u8bf7\u6c42\u6570\u636e\uff01");
        LogInfo logInfo = LOG_INFO_LOCAL.get();
        if (logInfo == null) {
            log.info("\u8bb0\u5f55\u8bf7\u6c42\u7684\u8bf7\u6c42\u65e5\u5fd7\u65f6\uff0c\u5f53\u524d\u7ebf\u7a0b\u65e5\u5fd7\u4fe1\u606f\u4e22\u5931\uff01");
            return;
        }
        Map parameterMap = httpServletRequest.getParameterMap();
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)parameterMap);
        logInfo.setRequestParam(String.valueOf(jsonObject));
        String requestMethod = httpServletRequest.getMethod();
        logInfo.setRequestMethod(requestMethod);
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        LinkedMultiValueMap requestHeaders = new LinkedMultiValueMap();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String header = httpServletRequest.getHeader(headerName);
            requestHeaders.add((Object)headerName, (Object)header);
        }
        logInfo.setRequestHeaders((MultiValueMap<String, String>)requestHeaders);
        Cookie[] cookies = httpServletRequest.getCookies();
        ArrayList<String> cookieList = new ArrayList<String>();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                String cook = "Cookie:" + name + "=" + value;
                cookieList.add(cook);
            }
        }
        logInfo.setRequestCookies(cookieList);
        log.info("\u5f53\u524d\u8bf7\u6c42\u7684\u8bf7\u6c42\u6570\u636e\u5904\u7406\u5b8c\u6210\uff01");
    }

    private LogInfo buildLogInfo(HttpServletRequest httpServletRequest, String contextPath) throws UnknownHostException, MalformedURLException {
        String referer;
        LogInfo logInfo = new LogInfo();
        logInfo.setLogId(UUID.randomUUID().toString());
        logInfo.setTenantCode(TenantUtils.getTenantCode());
        logInfo.setInvokeType(2);
        String receiptSysName = httpServletRequest.getHeader("receiptSysName");
        if (receiptSysName != null) {
            logInfo.setSourceSysName(receiptSysName);
            logInfo.setSysName(receiptSysName);
        }
        if (StringUtils.isNotBlank((CharSequence)(referer = httpServletRequest.getHeader("Referer")))) {
            URL refererUrl = new URL(referer);
            String refererDomain = refererUrl.getHost();
            String refererIp = InetAddress.getByName(refererDomain).getHostAddress();
            logInfo.setSourceDomain(refererIp);
        }
        String targetUrl = httpServletRequest.getRequestURL().toString();
        URL targetUrlObj = new URL(targetUrl);
        String targetDomain = targetUrlObj.getHost();
        String targetIp = InetAddress.getByName(targetDomain).getHostAddress();
        logInfo.setTargetDomain(targetIp);
        String requestURI = httpServletRequest.getRequestURI();
        String tempUrl = "";
        tempUrl = requestURI.toLowerCase().startsWith("http") ? requestURI : (requestURI.startsWith("/") ? "http://127.0.0.1" + requestURI : "http://127.0.0.1/" + requestURI);
        URL url = new URL(tempUrl);
        logInfo.setTargetPath(url.getPath());
        logInfo.setTargetPort(httpServletRequest.getLocalPort());
        logInfo.setTargetScheme(httpServletRequest.getScheme());
        logInfo.setTargetSysName(contextPath);
        return logInfo;
    }

    private List<InterfaceInvokeMonitor> validateUrl(String receiptSysName, String contextPath, String requestURI, String requestMethod) {
        List<InterfaceInvokeMonitor> interfaceInvokeMonitors;
        if (StringUtils.isNotBlank((CharSequence)requestMethod)) {
            requestMethod = StringUtils.upperCase((String)requestMethod);
        }
        if (CollectionUtils.isEmpty(interfaceInvokeMonitors = this.interfaceInvokeMonitorService.findByTargetAndSourceNameAndUrl(contextPath, receiptSysName, requestURI, requestMethod))) {
            return new ArrayList<InterfaceInvokeMonitor>(0);
        }
        return interfaceInvokeMonitors;
    }

    public void destroy() {
        super.destroy();
    }
}

