/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.monitor.local.config.MonitorProperties;
import com.bizunited.nebula.monitor.local.entity.AuthInterfaceRole;
import com.bizunited.nebula.monitor.local.model.AuthInterfaceModel;
import com.bizunited.nebula.monitor.local.repository.AuthInterfaceRoleMapperRepository;
import com.bizunited.nebula.monitor.local.repository.AuthInterfaceRoleRepository;
import com.bizunited.nebula.monitor.local.service.AuthInterfaceRoleService;
import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class AuthInterfaceRoleServiceImpl
implements AuthInterfaceRoleService {
    private static final Logger log = LoggerFactory.getLogger(AuthInterfaceRoleServiceImpl.class);
    @Autowired(required=false)
    private AuthInterfaceRoleRepository authInterfaceRoleRepository;
    @Autowired(required=false)
    private RedisTemplate<String, String> redisTemplate;
    @Autowired(required=false)
    private MonitorProperties monitorProperties;
    @Autowired(required=false)
    @Lazy
    private AuthInterfaceRoleMapperRepository authInterfaceRoleMapperRepository;

    @Override
    public Boolean checkRoleUrl(String roleCode, AuthInterfaceModel model) {
        Set authInterfaceModels = this.findRoleAuthInterfaceUrls(roleCode);
        authInterfaceModels = (Set)ObjectUtils.defaultIfNull(authInterfaceModels, (Object)Sets.newHashSet());
        Boolean result = Boolean.FALSE;
        for (AuthInterfaceModel authInterfaceModel : authInterfaceModels) {
            if (!Objects.equals(model.getInterfaceUrl(), authInterfaceModel.getInterfaceUrl()) || !Objects.equals(model.getRequestMethod(), authInterfaceModel.getRequestMethod())) continue;
            result = Boolean.TRUE;
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void autoAuthorization(String roleCode, AuthInterfaceModel model) {
        if (StringUtil.isEmpty((CharSequence)roleCode) || Objects.isNull(model)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)model.getInterfaceUrl()) || StringUtils.isBlank((CharSequence)model.getRequestMethod())) {
            return;
        }
        String onlyKey = StringUtils.stripToEmpty((String)roleCode) + StringUtils.stripToEmpty((String)model.getInterfaceUrl()) + StringUtils.stripToEmpty((String)model.getRequestMethod());
        String id = DigestUtils.md5DigestAsHex((byte[])onlyKey.getBytes(StandardCharsets.UTF_8));
        AuthInterfaceRole authInterfaceRole = new AuthInterfaceRole();
        authInterfaceRole.setId(id);
        authInterfaceRole.setTenantCode(TenantUtils.getTenantCode());
        authInterfaceRole.setRoleCode(roleCode);
        authInterfaceRole.setInterfaceUrl(model.getInterfaceUrl());
        authInterfaceRole.setRequestMethod(model.getRequestMethod());
        this.authInterfaceRoleMapperRepository.saveOrUpdate((Object)authInterfaceRole);
    }

    private Set<AuthInterfaceModel> findRoleAuthInterfaceUrls(String roleCode) {
        String mapName = String.join((CharSequence)":", this.monitorProperties.getApplicationName(), "REDIS_KEY_AUTH_INTERFACE_ROLE", TenantUtils.getTenantCode(), roleCode);
        Boolean hasKey = this.redisTemplate.hasKey((Object)mapName);
        if (!Boolean.TRUE.equals(hasKey)) {
            double currentTimeMillis = System.currentTimeMillis();
            AuthInterfaceModel defaultModel = new AuthInterfaceModel();
            defaultModel.setInterfaceUrl("default_url");
            defaultModel.setRequestMethod(RequestMethod.POST.name());
            this.redisTemplate.opsForZSet().add((Object)mapName, (Object)JSON.toJSONString((Object)defaultModel), currentTimeMillis);
            this.redisTemplate.expire((Object)mapName, 1L, TimeUnit.MINUTES);
            List<AuthInterfaceRole> authInterfaceRoles = this.authInterfaceRoleRepository.findByTenantCodeAndRoleCode(TenantUtils.getTenantCode(), roleCode);
            if (CollectionUtils.isNotEmpty(authInterfaceRoles)) {
                Set typedTuples = authInterfaceRoles.stream().map(authInterfaceRole -> {
                    AuthInterfaceModel model = new AuthInterfaceModel();
                    model.setInterfaceUrl(authInterfaceRole.getInterfaceUrl());
                    model.setRequestMethod(authInterfaceRole.getRequestMethod());
                    return new DefaultTypedTuple((Object)JSON.toJSONString((Object)model), Double.valueOf(currentTimeMillis));
                }).collect(Collectors.toSet());
                this.redisTemplate.opsForZSet().add((Object)mapName, typedTuples);
            }
        }
        Set jsonSet = this.redisTemplate.opsForZSet().range((Object)mapName, 0L, -1L);
        jsonSet = (Set)ObjectUtils.defaultIfNull((Object)jsonSet, (Object)Sets.newHashSet());
        return jsonSet.stream().map(json -> (AuthInterfaceModel)JSON.parseObject((String)json, AuthInterfaceModel.class)).collect(Collectors.toSet());
    }
}

