/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.monitor.sdk.bo.Cpu;
import com.bizunited.nebula.monitor.sdk.bo.Disk;
import com.bizunited.nebula.monitor.sdk.bo.Memory;
import com.bizunited.nebula.monitor.sdk.bo.MonitorAllBo;
import com.bizunited.nebula.monitor.sdk.service.MonitorService;
import com.bizunited.nebula.monitor.sdk.utils.NumberUtil;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;

@Service
public class MonitorServiceImpl
implements MonitorService {
    private ThreadLocal<JSONObject> operatingSystemLocal = new ThreadLocal();
    private static final int CPU_AVAILABLEP_ROCSSORS = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getOperatingSystemJson() {
        JSONObject jsonObject = this.operatingSystemLocal.get();
        if (jsonObject != null) {
            return jsonObject;
        }
        ThreadLocal<JSONObject> threadLocal = this.operatingSystemLocal;
        synchronized (threadLocal) {
            jsonObject = this.operatingSystemLocal.get();
            if (jsonObject != null) {
                return jsonObject;
            }
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            JSONObject operatingSystemJson = JSON.parseObject((String)JSON.toJSONString((Object)operatingSystemMXBean));
            this.operatingSystemLocal.set(operatingSystemJson);
            return operatingSystemJson;
        }
    }

    public Cpu getCpu() {
        JSONObject operatingSystemJson = this.getOperatingSystemJson();
        return Cpu.builder().availableProcssors(CPU_AVAILABLEP_ROCSSORS).systemCpuUsage(operatingSystemJson.getDoubleValue("systemCpuLoad")).processCpuUsage(operatingSystemJson.getDoubleValue("processCpuLoad")).build();
    }

    public Memory getMemory() {
        JSONObject operatingSystemJson = this.getOperatingSystemJson();
        long totalPhysicalMemory = operatingSystemJson.getLongValue("totalPhysicalMemorySize");
        long freePhysicalMemory = operatingSystemJson.getLongValue("freePhysicalMemorySize");
        long usedPhysicalMemory = totalPhysicalMemory - freePhysicalMemory;
        Runtime runtime = Runtime.getRuntime();
        return Memory.builder().totalPhysicalMemory(totalPhysicalMemory).freePhysicalMemory(freePhysicalMemory).usedPhysicalMemory(usedPhysicalMemory).physicalMemoryUsage(NumberUtil.toBigDecimal((Number)NumberUtil.div((float)usedPhysicalMemory, (float)totalPhysicalMemory)).doubleValue()).totalMemory(runtime.totalMemory()).freeMemory(runtime.freeMemory()).usedMemory(runtime.totalMemory() - runtime.freeMemory()).maxMemory(runtime.maxMemory()).maxUseMemory(runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory()).memoryUsage(NumberUtil.toBigDecimal((Number)NumberUtil.div((float)(runtime.totalMemory() - runtime.freeMemory()), (float)runtime.totalMemory())).doubleValue()).build();
    }

    public Disk getDisk() {
        List drives = Stream.of(File.listRoots()).map(file -> Disk.Drive.builder().name(file.toString()).totalSpace(file.getTotalSpace()).freeSpace(file.getFreeSpace()).usedSpace(file.getTotalSpace() - file.getFreeSpace()).driveUsage(NumberUtil.toBigDecimal((Number)NumberUtil.div((float)(file.getTotalSpace() - file.getFreeSpace()), (float)file.getTotalSpace())).doubleValue()).build()).collect(Collectors.toList());
        return new Disk(drives);
    }

    public MonitorAllBo getAll() {
        MonitorAllBo allBo = new MonitorAllBo();
        Cpu cpu = this.getCpu();
        Disk disk = this.getDisk();
        Memory memory = this.getMemory();
        allBo.setCpu(cpu);
        allBo.setDisk(disk);
        allBo.setMemory(memory);
        return allBo;
    }

    public static void main(String[] args) {
        MonitorServiceImpl ms = new MonitorServiceImpl();
        MonitorAllBo all = ms.getAll();
        Cpu cpu = all.getCpu();
        System.out.println(cpu);
        Memory memory = all.getMemory();
        System.out.println(memory);
        Disk disk = all.getDisk();
        System.out.println(disk);
    }
}

