/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.rest.service.Impl;

import com.bizunited.nebula.common.util.SpringBeanUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.monitor.local.elasticsearch.modle.LogInfo;
import com.bizunited.nebula.monitor.local.elasticsearch.service.Impl.LogPersistenceServiceImpl;
import com.bizunited.nebula.monitor.rest.utils.ClientHttpRequestInterceptorForLogUtils;
import com.bizunited.nebula.monitor.rest.utils.HttpRequestUtils;
import com.bizunited.nebula.monitor.sdk.model.ToUrlInterfaceDto;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;

public class ClientHttpRequestInterceptorForLog
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ClientHttpRequestInterceptorForLog.class);
    private static final ThreadLocal<LogInfo> LOG_INFO_LOCAL = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        LogInfo logInfo = this.getNewLogInfo(request);
        LOG_INFO_LOCAL.set(logInfo);
        ClientHttpResponse clientHttpResponse = null;
        try {
            Thread.currentThread().setName("\u5916\u90e8REST\u53d1\u9001 -thread -" + Thread.currentThread().getId());
            this.tranceRequest(request, body);
            logInfo.setRequestTime(System.currentTimeMillis());
            try {
                clientHttpResponse = execution.execute(request, body);
            }
            finally {
                logInfo.setResponseTime(System.currentTimeMillis());
            }
            long executeTime = logInfo.getResponseTime() - logInfo.getRequestTime();
            logInfo.setExecuteTime(executeTime);
            this.tranceResponse(clientHttpResponse);
            this.saveLogInfoEs();
        }
        finally {
            LOG_INFO_LOCAL.remove();
        }
        return clientHttpResponse;
    }

    private void saveLogInfoEs() {
        LogInfo logInfo = LOG_INFO_LOCAL.get();
        ApplicationContext applicationContext = SpringBeanUtils.getApplicationContext();
        if (applicationContext == null) {
            log.error("\u7cfb\u7edf\u6ca1\u6709\u52a0\u8f7dspring , \u5ffd\u7565\u672c\u6b21\u6570\u636e\u4fdd\u5b58 : {}", (Object)logInfo);
            return;
        }
        LogPersistenceServiceImpl logPersistenceService = (LogPersistenceServiceImpl)applicationContext.getBean(LogPersistenceServiceImpl.class);
        logPersistenceService.saveLogInfo(logInfo);
    }

    private void tranceResponse(ClientHttpResponse clientHttpResponse) throws IOException {
        LogInfo logInfo = LOG_INFO_LOCAL.get();
        int statusCode = clientHttpResponse.getRawStatusCode();
        logInfo.setResponseStatusCode(statusCode);
        if (statusCode != 200) {
            log.error("HTTP \u72b6\u6001\u7801\u9519\u8bef: \u5e94\u5f53\u662f 200 \u5b9e\u9645\u5374\u662f {}", (Object)statusCode);
            return;
        }
        logInfo.setResponseStatusText(clientHttpResponse.getStatusText());
        InputStream inputStream = clientHttpResponse.getBody();
        log.info("============================ response begin ============================");
        log.info("status code   : {}", (Object)logInfo.getResponseStatusCode());
        log.info("status text   : {}", (Object)logInfo.getResponseStatusText());
        HttpHeaders httpHeaders = clientHttpResponse.getHeaders();
        List cookies = httpHeaders.remove((Object)"Set-Cookie");
        logInfo.setResponseHeaders((MultiValueMap<String, String>)httpHeaders);
        logInfo.setResponseCookies(cookies);
        log.info("Headers      : {}", (Object)logInfo.getResponseHeaders());
        log.info("Cookie       : {}", (Object)logInfo.getResponseCookies());
        try (ByteArrayOutputStream ops = new ByteArrayOutputStream();){
            StreamUtils.copy((InputStream)inputStream, (OutputStream)ops);
            byte[] bytes = ops.toByteArray();
            logInfo.setResponseBody(new String(bytes, "UTF-8"));
            log.info("RESULT:{}", (Object)logInfo.getResponseBody());
        }
        catch (Exception e) {
            log.error("\u53c2\u6570\u8f6c\u6362 \u590d\u5236\u6d41\u5f02\u5e38", (Throwable)e);
        }
        log.info("============================= response end =============================");
    }

    private void tranceRequest(HttpRequest request, byte[] body) throws UnsupportedEncodingException {
        URI uri = request.getURI();
        List<String> queryParams = HttpRequestUtils.buildQueryParams(request);
        LogInfo logInfo = LOG_INFO_LOCAL.get();
        log.info("=========================== \u63a5\u6536\u7cfb\u7edf\u9644\u52a0\u4fe1\u606f ===========================");
        log.info("\u63a5\u6536\u7cfb\u7edf        : {}", (Object)logInfo.getSysName());
        log.info("\u63a5\u53e3\u63cf\u8ff0        : {}", (Object)logInfo.getSysDesc());
        log.info("=========================== request begin ===========================");
        log.info("uri            : {}", (Object)uri);
        log.info("uri.targetScheme     : {}", (Object)logInfo.getTargetScheme());
        log.info("uri.targetDomain  : {}", (Object)logInfo.getTargetDomain());
        log.info("uri.Path       : {}", (Object)logInfo.getTargetPath());
        logInfo.setRequestMethod(request.getMethod().toString());
        logInfo.setRequestParam(StringUtils.join(queryParams, (String)","));
        log.info("method   : {}", (Object)logInfo.getRequestMethod());
        log.info("queryParams    : {}", (Object)logInfo.getRequestParam());
        HttpHeaders headers = request.getHeaders();
        List cookies = headers.remove((Object)"Cookie");
        logInfo.setRequestHeaders((MultiValueMap<String, String>)headers);
        logInfo.setRequestCookies(cookies);
        logInfo.setRequestBody(new String(body, "UTF-8"));
        log.info("headers   : {}", (Object)logInfo.getRequestHeaders());
        log.info("COOKIE    : {}", (Object)logInfo.getRequestCookies());
        log.info("request body  : {}", (Object)logInfo.getRequestBody());
        log.info("============================ request end ============================");
    }

    private LogInfo getNewLogInfo(HttpRequest request) throws UnknownHostException {
        URI uri = request.getURI();
        LogInfo logInfo = new LogInfo();
        logInfo.setLogId(UUID.randomUUID().toString());
        logInfo.setTenantCode(TenantUtils.getTenantCode());
        logInfo.setInvokeType(1);
        ToUrlInterfaceDto toUrlInterfaceDto = ClientHttpRequestInterceptorForLogUtils.getToUrlInterfaceDto();
        if (!Objects.isNull(toUrlInterfaceDto)) {
            logInfo.setSysName(toUrlInterfaceDto.getTargetSysName());
            logInfo.setSysDesc(toUrlInterfaceDto.getInterfaceDesc());
            logInfo.setTargetSysName(toUrlInterfaceDto.getTargetSysName());
            logInfo.setSourceSysName(toUrlInterfaceDto.getSourceSysName());
            logInfo.setSourceSysDesc(toUrlInterfaceDto.getSourceSysDesc());
        }
        String host = uri.getHost();
        String hostAddress = InetAddress.getByName(host).getHostAddress();
        logInfo.setSourceDomain(hostAddress);
        logInfo.setTargetScheme(uri.getScheme());
        logInfo.setTargetDomain(uri.getAuthority());
        logInfo.setTargetPath(uri.getPath());
        logInfo.setTargetPort(uri.getPort());
        return logInfo;
    }
}

