/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.sdk.bo;

import com.bizunited.nebula.monitor.sdk.serializer.SerializerDouble;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class Cpu {
    private int availableProcssors;
    @JsonFormat(pattern="#.#########", shape=JsonFormat.Shape.NUMBER_FLOAT)
    @JsonSerialize(using=SerializerDouble.class)
    private double systemCpuUsage;
    @JsonFormat(pattern="#.#########", shape=JsonFormat.Shape.NUMBER_FLOAT)
    @JsonSerialize(using=SerializerDouble.class)
    private double processCpuUsage;

    public static CpuBuilder builder() {
        return new CpuBuilder();
    }

    public int getAvailableProcssors() {
        return this.availableProcssors;
    }

    public double getSystemCpuUsage() {
        return this.systemCpuUsage;
    }

    public double getProcessCpuUsage() {
        return this.processCpuUsage;
    }

    public void setAvailableProcssors(int availableProcssors) {
        this.availableProcssors = availableProcssors;
    }

    @JsonFormat(pattern="#.#########", shape=JsonFormat.Shape.NUMBER_FLOAT)
    public void setSystemCpuUsage(double systemCpuUsage) {
        this.systemCpuUsage = systemCpuUsage;
    }

    @JsonFormat(pattern="#.#########", shape=JsonFormat.Shape.NUMBER_FLOAT)
    public void setProcessCpuUsage(double processCpuUsage) {
        this.processCpuUsage = processCpuUsage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cpu)) {
            return false;
        }
        Cpu other = (Cpu)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAvailableProcssors() != other.getAvailableProcssors()) {
            return false;
        }
        if (Double.compare(this.getSystemCpuUsage(), other.getSystemCpuUsage()) != 0) {
            return false;
        }
        return Double.compare(this.getProcessCpuUsage(), other.getProcessCpuUsage()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cpu;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAvailableProcssors();
        long $systemCpuUsage = Double.doubleToLongBits(this.getSystemCpuUsage());
        result = result * 59 + (int)($systemCpuUsage >>> 32 ^ $systemCpuUsage);
        long $processCpuUsage = Double.doubleToLongBits(this.getProcessCpuUsage());
        result = result * 59 + (int)($processCpuUsage >>> 32 ^ $processCpuUsage);
        return result;
    }

    public String toString() {
        return "Cpu(availableProcssors=" + this.getAvailableProcssors() + ", systemCpuUsage=" + this.getSystemCpuUsage() + ", processCpuUsage=" + this.getProcessCpuUsage() + ")";
    }

    public Cpu() {
    }

    public Cpu(int availableProcssors, double systemCpuUsage, double processCpuUsage) {
        this.availableProcssors = availableProcssors;
        this.systemCpuUsage = systemCpuUsage;
        this.processCpuUsage = processCpuUsage;
    }

    public static class CpuBuilder {
        private int availableProcssors;
        private double systemCpuUsage;
        private double processCpuUsage;

        CpuBuilder() {
        }

        public CpuBuilder availableProcssors(int availableProcssors) {
            this.availableProcssors = availableProcssors;
            return this;
        }

        @JsonFormat(pattern="#.#########", shape=JsonFormat.Shape.NUMBER_FLOAT)
        public CpuBuilder systemCpuUsage(double systemCpuUsage) {
            this.systemCpuUsage = systemCpuUsage;
            return this;
        }

        @JsonFormat(pattern="#.#########", shape=JsonFormat.Shape.NUMBER_FLOAT)
        public CpuBuilder processCpuUsage(double processCpuUsage) {
            this.processCpuUsage = processCpuUsage;
            return this;
        }

        public Cpu build() {
            return new Cpu(this.availableProcssors, this.systemCpuUsage, this.processCpuUsage);
        }

        public String toString() {
            return "Cpu.CpuBuilder(availableProcssors=" + this.availableProcssors + ", systemCpuUsage=" + this.systemCpuUsage + ", processCpuUsage=" + this.processCpuUsage + ")";
        }
    }
}

