/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.sdk.bo;

import com.bizunited.nebula.monitor.sdk.serializer.SerializerDouble;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;

public class Disk {
    private List<Drive> devices;

    public List<Drive> getDevices() {
        return this.devices;
    }

    public void setDevices(List<Drive> devices) {
        this.devices = devices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Disk)) {
            return false;
        }
        Disk other = (Disk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Drive> this$devices = this.getDevices();
        List<Drive> other$devices = other.getDevices();
        return !(this$devices == null ? other$devices != null : !((Object)this$devices).equals(other$devices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Disk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Drive> $devices = this.getDevices();
        result = result * 59 + ($devices == null ? 43 : ((Object)$devices).hashCode());
        return result;
    }

    public String toString() {
        return "Disk(devices=" + this.getDevices() + ")";
    }

    public Disk() {
    }

    public Disk(List<Drive> devices) {
        this.devices = devices;
    }

    public static class Drive {
        private String name;
        private long totalSpace;
        private long freeSpace;
        private long usedSpace;
        @JsonFormat(pattern="#.#########", shape=JsonFormat.Shape.NUMBER_FLOAT)
        @JsonSerialize(using=SerializerDouble.class)
        private double driveUsage;

        public static DriveBuilder builder() {
            return new DriveBuilder();
        }

        public String getName() {
            return this.name;
        }

        public long getTotalSpace() {
            return this.totalSpace;
        }

        public long getFreeSpace() {
            return this.freeSpace;
        }

        public long getUsedSpace() {
            return this.usedSpace;
        }

        public double getDriveUsage() {
            return this.driveUsage;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTotalSpace(long totalSpace) {
            this.totalSpace = totalSpace;
        }

        public void setFreeSpace(long freeSpace) {
            this.freeSpace = freeSpace;
        }

        public void setUsedSpace(long usedSpace) {
            this.usedSpace = usedSpace;
        }

        @JsonFormat(pattern="#.#########", shape=JsonFormat.Shape.NUMBER_FLOAT)
        public void setDriveUsage(double driveUsage) {
            this.driveUsage = driveUsage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Drive)) {
                return false;
            }
            Drive other = (Drive)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotalSpace() != other.getTotalSpace()) {
                return false;
            }
            if (this.getFreeSpace() != other.getFreeSpace()) {
                return false;
            }
            if (this.getUsedSpace() != other.getUsedSpace()) {
                return false;
            }
            if (Double.compare(this.getDriveUsage(), other.getDriveUsage()) != 0) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Drive;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $totalSpace = this.getTotalSpace();
            result = result * 59 + (int)($totalSpace >>> 32 ^ $totalSpace);
            long $freeSpace = this.getFreeSpace();
            result = result * 59 + (int)($freeSpace >>> 32 ^ $freeSpace);
            long $usedSpace = this.getUsedSpace();
            result = result * 59 + (int)($usedSpace >>> 32 ^ $usedSpace);
            long $driveUsage = Double.doubleToLongBits(this.getDriveUsage());
            result = result * 59 + (int)($driveUsage >>> 32 ^ $driveUsage);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "Disk.Drive(name=" + this.getName() + ", totalSpace=" + this.getTotalSpace() + ", freeSpace=" + this.getFreeSpace() + ", usedSpace=" + this.getUsedSpace() + ", driveUsage=" + this.getDriveUsage() + ")";
        }

        public Drive() {
        }

        public Drive(String name, long totalSpace, long freeSpace, long usedSpace, double driveUsage) {
            this.name = name;
            this.totalSpace = totalSpace;
            this.freeSpace = freeSpace;
            this.usedSpace = usedSpace;
            this.driveUsage = driveUsage;
        }

        public static class DriveBuilder {
            private String name;
            private long totalSpace;
            private long freeSpace;
            private long usedSpace;
            private double driveUsage;

            DriveBuilder() {
            }

            public DriveBuilder name(String name) {
                this.name = name;
                return this;
            }

            public DriveBuilder totalSpace(long totalSpace) {
                this.totalSpace = totalSpace;
                return this;
            }

            public DriveBuilder freeSpace(long freeSpace) {
                this.freeSpace = freeSpace;
                return this;
            }

            public DriveBuilder usedSpace(long usedSpace) {
                this.usedSpace = usedSpace;
                return this;
            }

            @JsonFormat(pattern="#.#########", shape=JsonFormat.Shape.NUMBER_FLOAT)
            public DriveBuilder driveUsage(double driveUsage) {
                this.driveUsage = driveUsage;
                return this;
            }

            public Drive build() {
                return new Drive(this.name, this.totalSpace, this.freeSpace, this.usedSpace, this.driveUsage);
            }

            public String toString() {
                return "Disk.Drive.DriveBuilder(name=" + this.name + ", totalSpace=" + this.totalSpace + ", freeSpace=" + this.freeSpace + ", usedSpace=" + this.usedSpace + ", driveUsage=" + this.driveUsage + ")";
            }
        }
    }
}

