/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.sdk.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;

public class NumberUtil {
    private static final int DEFAULT_DIV_SCALE = 10;

    public static double div(float v1, float v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static double div(double v1, float v2, int scale) {
        return NumberUtil.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, float v2, int scale, RoundingMode roundingMode) {
        return NumberUtil.div(Double.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        return NumberUtil.div(NumberUtil.toBigDecimal(v1), NumberUtil.toBigDecimal(v2), scale, roundingMode);
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale, RoundingMode roundingMode) {
        if (v2 == null) {
            throw new RuntimeException("Divisor must be not null !");
        }
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return v1.divide(v2, scale, roundingMode);
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return NumberUtil.toBigDecimal(number.toString());
    }

    public static BigDecimal toBigDecimal(String numberStr) {
        if (StringUtils.isBlank((CharSequence)numberStr)) {
            return BigDecimal.ZERO;
        }
        try {
            Number number = NumberUtil.parseNumber(numberStr);
            if (number instanceof BigDecimal) {
                return (BigDecimal)number;
            }
            return new BigDecimal(number.toString());
        }
        catch (Exception exception) {
            return new BigDecimal(numberStr);
        }
    }

    public static BigInteger toBigInteger(Number number) {
        if (null == number) {
            return BigInteger.ZERO;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof Long) {
            return BigInteger.valueOf((Long)number);
        }
        return NumberUtil.toBigInteger(number.longValue());
    }

    public static BigInteger toBigInteger(String number) {
        return StringUtils.isBlank((CharSequence)number) ? BigInteger.ZERO : new BigInteger(number);
    }

    public static Number parseNumber(String numberStr) throws NumberFormatException {
        if (StringUtils.startsWithIgnoreCase((CharSequence)numberStr, (CharSequence)"0x")) {
            return Long.parseLong(numberStr.substring(2), 16);
        }
        try {
            NumberFormat format = NumberFormat.getInstance();
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setParseBigDecimal(true);
            }
            return format.parse(numberStr);
        }
        catch (ParseException e) {
            NumberFormatException nfe = new NumberFormatException(e.getMessage());
            nfe.initCause(e);
            throw nfe;
        }
    }
}

