/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.rbac.sdk.service.RoleVoService;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rbac/roles"})
public class RoleVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleVoController.class);
    @Autowired
    private RoleVoService roleVoService;

    @ApiOperation(value="\u6dfb\u52a0\u4e00\u4e2a\u89d2\u8272\u4fe1\u606f")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel createRole(@RequestBody @ApiParam(value="role", name="\u65b0\u5efa\u7684\u89d2\u8272\u5bf9\u8c61") RoleVo role) {
        try {
            if (role == null) {
                throw new IllegalArgumentException("role info not be null!");
            }
            RoleVo currentRole = this.roleVoService.create(role);
            return this.buildHttpResultW(currentRole, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u4e00\u4e2a\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u6ce8\u610f\u914d\u7f6e\u5728roles.sDeny\u5c5e\u6027\u7684\u4fe1\u606f\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u3002\u4e14\u6307\u5b9a\u7684\u4e00\u4e2a\u89d2\u8272\u53ea\u80fd\u4fee\u6539\u89d2\u8272\u7684comment\u4fe1\u606f")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel updateRole(@RequestBody @ApiParam(value="role", name="\u4fee\u6539\u7684\u89d2\u8272\u5bf9\u8c61") RoleVo role) {
        try {
            RoleVo currentRole = this.roleVoService.update(role);
            return this.buildHttpResultW(currentRole, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u91cd\u65b0\u542f\u7528\u67d0\u4e00\u4e2a\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f")
    @RequestMapping(value={"/enable"}, method={RequestMethod.POST, RequestMethod.PATCH})
    public ResponseModel enableRole(@RequestParam(value="roleIds") String[] roleIds) {
        try {
            this.roleVoService.enable(roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7981\u7528\u67d0\u4e00\u4e2a\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff08\u76f8\u5f53\u4e8e\u5220\u9664\uff09<br>\u53ea\u662f\u7cfb\u7edf\u4e2d\u4e0d\u80fd\u771f\u6b63\u7684\u5220\u9664\u67d0\u4e00\u4e2a\u89d2\u8272\uff0c\u53ea\u80fd\u662f\u5c06\u8fd9\u4e2a\u89d2\u8272\u4f5c\u5e9f\u6389\u6216\u8005\u6062\u590d\u6b63\u5e38\u72b6\u6001")
    @RequestMapping(value={"/disable"}, method={RequestMethod.POST, RequestMethod.PATCH})
    public ResponseModel disableRole(@RequestParam(value="roleIds") String[] roleIds) {
        try {
            this.roleVoService.disable(roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f")
    @PostMapping(value={"/delete"})
    public ResponseModel delete(@RequestParam(value="roleCodes") String[] roleCodes) {
        try {
            this.roleVoService.deleteByRoleCodes(roleCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u590d\u5236\u89d2\u8272,\u4e3b\u8981\u662f\u9700\u8981\u63a5\u53e3\u540c\u6b65\u590d\u5236\u529f\u80fd\u6743\u9650")
    @RequestMapping(value={"/copy"}, method={RequestMethod.POST, RequestMethod.PATCH})
    public ResponseModel copy(@RequestBody RoleVo vo) {
        try {
            this.roleVoService.copy(vo);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

